package com.bcxin.survey.enums.report;


public enum SurveyManTaskStatus {

	/** 已领取 */
	RECEIVE {public String getValue(){return "0";} public String getName(){return "已领取";}}, 
	/** 进行中*/
	DOING {public String getValue(){return "1";} public String getName(){return "进行中";}},
	/** 勘察结束 */
	DONE {public String getValue(){return "2";} public String getName(){return "勘察结束";}}, 
	/** 其他*/
	OTHER{public String getValue(){return "9";} public String getName(){return "其他";}};
	
    public abstract String getValue();
    
    public abstract String getName();
    
    public static SurveyManTaskStatus convert(String value){
    	if ( "DONE".equals(value) ) {
    		return SurveyManTaskStatus.DONE;
    	} else if ("DOING".equals(value)) {
    		return SurveyManTaskStatus.DOING;
    	} else if ("RECEIVE".equals(value)) {
    		return SurveyManTaskStatus.RECEIVE;
    	}
    	return SurveyManTaskStatus.OTHER;
    }
}
