package com.bcxin.survey.enums.dynamic;

/**
 * @author hzp
 * 动态看板类型
 */
public enum DynamicTypeEnum {

    DYNAMIC_ORDER("100","订单动态"),
    DYNAMIC_FENGPING("200","风评动态"),
    DYNAMIC_ZHUANXIE("300","撰写动态"),
    DYNAMIC_KANCHA("400","勘查动态");

    private String key;
    private String alias;

    DynamicTypeEnum(String key, String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(DynamicTypeEnum e : DynamicTypeEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
