package com.bcxin.survey.dto;

import com.bcxin.survey.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

@JsonIgnoreProperties(value={"hibernateLazyInitializer"})
@Data
public class ActivityCooperDTO implements Serializable {

	private static final long serialVersionUID = -8149334196024089736L;

	private String oid;
	
	private String name;
	
	private String serviceOrgType;
	
	private String contactPhone;

	private String contactEmail ; 
	
	private String contactName;
	
	private String amount;

	/**
	 * 服务模式
	 */
	private String serviceMode;

	// 是否开启踏勘系统权限
	private String openTK;

	private String financePhone;

	private String rcpoid;
	
	private String typeCN;

	private String distributionOrg;

	private String cooperOid;

	private String orderId;

	private String activityId;

	private String orgId;

	/**
	 * 报价
	 */
	private String quote;

	/**
	 * 被选中的服务机构
	 */
	private String selected;


	/*评估公司最低报价*/
	private String minQuote;

	// 盖章图片
	private String stampedPicture;

	// 审核状态
	private String approvalStatus;

	/* 联动优势商户号 */
	private String umpayMerId;


	public ActivityCooperDTO(){}
	
	
	public ActivityCooperDTO(Map<String,Object> map){
		this.oid = safeTransfor(map.get("oid"));
		this.name = safeTransfor(map.get("name"));
		if ( this.name != null && this.name.length() > 20 ) {
			this.name = this.name.substring(0,20)+"..";
		}
		this.serviceOrgType = safeTransfor(map.get("serviceOrgType"));
		this.contactPhone = safeTransfor(map.get("contactPhone"));
		this.contactEmail = safeTransfor(map.get("contactEmail"));
		this.contactName = safeTransfor(map.get("contactName"));
		this.amount = safeTransfor(map.get("amount"));
		if ( StringUtil.isEmpty(this.amount) ) {
			this.amount = "0";
		}
		this.serviceMode = safeTransfor(map.get("serviceMode"));
		this.openTK=safeTransfor(map.get("openTK"));
		this.rcpoid = safeTransfor(map.get("rcpoid"));
		this.distributionOrg = safeTransfor(map.get("distributionorg"));
		this.financePhone = safeTransfor(map.get("financePhone"));
		this.cooperOid = safeTransfor(map.get("cooperOid"));
		this.orderId = safeTransfor(map.get("orderId"));
		this.orgId = safeTransfor(map.get("orgId"));
		this.activityId = safeTransfor(map.get("activityId"));
		this.umpayMerId = safeTransfor(map.get("umpayMerId"));
		this.stampedPicture = safeTransfor(map.get("stampedPicture"));
		this.approvalStatus = safeTransfor(map.get("approvalStatus"));
		this.minQuote = safeTransfor(map.get("minQuote"));
	}
	
	
	/**
     * 
     * <b>Function 将Object安全转换为String</b> 
     * 
     * @param obj
     * @return
     * @author LuoPeng
     * @date 2016年12月22日 下午5:17:02
     * @注意事项 </b>
     * <b>
     */
    private String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}
}