package com.bcxin.survey.domain.venue;

import com.bcxin.survey.domain.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 会展场馆
 * @author 070
 */
@Entity
@Table(name = "venue_Base")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class VenueBase extends BaseBean {

    /** 场地名称 */
    private String name;

    /** 所属省 */
    @Transient
    private String provinceName="";

    /** 所属省代码 */
    private String province;

    /** 所属市 */
    @Transient
    private String cityName="";

    /** 所属市代码 */
    private String city;

    /** 联系电话 */
    private String phone;

    /** 场地类型 */
    private String venueType;
    /**
     * 来源 （0代表共享，1代表私有）
     */
    private String nature;

    /** 创建者id */
    private Long userId;

    /** 地址 */
    private String venueAddress;

    /** 上级id */
    private Long parentId;

    public static VenueBase venueBaseInit(String venueType){
        VenueBase venueBase = new VenueBase();
        switch (venueType){
            case "1":
                venueBase = new VenueStadium();
                break;
            case "2":
                venueBase = new VenueExhibition();
                break;
            case "3":
                venueBase = new VenueOutdoor();
                break;
            case "4":
                venueBase = new VenueExhibitionHall();
                break;
            default:
                break;
        }
        return venueBase;
    }
}