package com.bcxin.survey.domain.survey;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.bcxin.survey.enums.report.FeedBackStatusEnum;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import com.bcxin.survey.domain.BaseBean;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.enums.report.SurveyStep;
import com.bcxin.survey.enums.report.TaskStatus;

/**
 * 查勘反馈
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_Survey_FeedBack")
@Inheritance(strategy = InheritanceType.JOINED)
@Proxy(proxyClass = Survey_FeedBack.class)
@DynamicInsert(true)
@DynamicUpdate(true)
public class Survey_FeedBack extends BaseBean{

	 
	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = SurveyTask.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "taskId")
	private SurveyTask surveyTask = new SurveyTask(); //对应勘查任务

	// 勘查员工号
	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "userId")
	private User user = new User();
	
	@Enumerated(EnumType.STRING)
	private SurveyStep surveyStep;//勘查阶段

	@ManyToMany(targetEntity = User.class, cascade = CascadeType.ALL, fetch = FetchType.LAZY)
	@JoinTable(name = "risk_feedBack_Expert",joinColumns = { @JoinColumn(name = "feedBackId") }, inverseJoinColumns = { @JoinColumn(name = "expertId") })
    private List<User> experts = new ArrayList<User>();

	//各勘查计划
	@OneToMany(targetEntity = SurveyPlan.class, cascade = CascadeType.REMOVE, mappedBy="feedBack", fetch = FetchType.LAZY)
    private List<SurveyPlan> surveyPlans = new ArrayList<SurveyPlan>();
    
	//各勘查项目明细
	@OneToMany(targetEntity = Survey_Questionnaire.class, cascade = CascadeType.REMOVE, mappedBy="feedBack", fetch = FetchType.LAZY)
    private List<Survey_Questionnaire> questionnaires = new ArrayList<Survey_Questionnaire>();

	// 反馈表任务状态
	@Enumerated(EnumType.STRING)
	private FeedBackStatusEnum taskStatus;
	
	private String remark;//备注

	public SurveyTask getSurveyTask() {
		return surveyTask;
	}

	public void setSurveyTask(SurveyTask surveyTask) {
		this.surveyTask = surveyTask;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public SurveyStep getSurveyStep() {
		return surveyStep;
	}

	public void setSurveyStep(SurveyStep surveyStep) {
		this.surveyStep = surveyStep;
	}

	public List<User> getExperts() {
		return experts;
	}

	public void setExperts(List<User> experts) {
		this.experts = experts;
	}

	public List<SurveyPlan> getSurveyPlans() {
		return surveyPlans;
	}

	public void setSurveyPlans(List<SurveyPlan> surveyPlans) {
		this.surveyPlans = surveyPlans;
	}

	public List<Survey_Questionnaire> getQuestionnaires() {
		return questionnaires;
	}

	public void setQuestionnaires(List<Survey_Questionnaire> questionnaires) {
		this.questionnaires = questionnaires;
	}

	public FeedBackStatusEnum getTaskStatus() {
		return taskStatus;
	}

	public void setTaskStatus(FeedBackStatusEnum taskStatus) {
		this.taskStatus = taskStatus;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}


}
