package com.bcxin.survey.domain.survey;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import com.bcxin.survey.domain.BaseBean;
import com.bcxin.survey.domain.activity.Activity;
import com.bcxin.survey.domain.report.Task;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.enums.report.SurveyTaskStatus;

/**
 * 勘查任务
 * @author bcxin
 *
 */

@Entity
@Table(name = "RISK_SURVEYTASK")
@Proxy(proxyClass = SurveyTask.class)
@Inheritance(strategy = InheritanceType.JOINED)
@DynamicInsert(true)
@DynamicUpdate(true)
public class SurveyTask extends BaseBean{

	private static final long serialVersionUID = 1L;

	private String taskCode; // 任务编号

	@ManyToOne(targetEntity = Task.class, fetch = FetchType.EAGER)
	@JoinColumn(name = "taskId")
	private Task task; // 对应任务
	
	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activityId")
	private Activity activity;// 报告
	
	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "userId")
	private User user = new User(); // 勘查员工号

	//各勘查计划
	@OneToMany(targetEntity = SurveyPlan.class , cascade = CascadeType.ALL, mappedBy="surveyTask", fetch = FetchType.LAZY)
	@OrderBy("time")
    private List<SurveyPlan> surveyPlan = new ArrayList<SurveyPlan>();
    
	//各勘查阶段
	@OneToMany(targetEntity = Survey_FeedBack.class , cascade = CascadeType.ALL, mappedBy="surveyTask", fetch = FetchType.LAZY)
	@OrderBy("surveyStep")
    private List<Survey_FeedBack> feedBacks = new ArrayList<Survey_FeedBack>();
	    
	private String name;//项目名称

	@Enumerated(EnumType.STRING)
	private SurveyTaskStatus surveyTaskStatus; // 状态

	private Date activityTime;//活动开始时间
	
	private Date endTime;//活动结束时间
	
	private String address;//活动地点
	
	private String contacts;//联系人
	
	private String contactMobile;//联系电话

	public String getTaskCode() {
		return taskCode;
	}

	public void setTaskCode(String taskCode) {
		this.taskCode = taskCode;
	}

	public Task getTask() {
		return task;
	}

	public void setTask(Task task) {
		this.task = task;
	}

	public Activity getActivity() {
		return activity;
	}

	public void setActivity(Activity activity) {
		this.activity = activity;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public List<SurveyPlan> getSurveyPlan() {
		return surveyPlan;
	}

	public void setSurveyPlan(List<SurveyPlan> surveyPlan) {
		this.surveyPlan = surveyPlan;
	}
	
	public List<Survey_FeedBack> getFeedBacks() {
		return feedBacks;
	}

	public void setFeedBacks(List<Survey_FeedBack> feedBacks) {
		this.feedBacks = feedBacks;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public SurveyTaskStatus getSurveyTaskStatus() {
		return surveyTaskStatus;
	}

	public void setSurveyTaskStatus(SurveyTaskStatus surveyTaskStatus) {
		this.surveyTaskStatus = surveyTaskStatus;
	}

	public Date getActivityTime() {
		return activityTime;
	}

	public void setActivityTime(Date activityTime) {
		this.activityTime = activityTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}
	
	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getContacts() {
		return contacts;
	}

	public void setContacts(String contacts) {
		this.contacts = contacts;
	}

	public String getContactMobile() {
		return contactMobile;
	}

	public void setContactMobile(String contactMobile) {
		this.contactMobile = contactMobile;
	}

}
