package com.bcxin.survey.domain.survey;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import com.bcxin.survey.domain.BaseBean;
import com.bcxin.survey.enums.report.TagType;

/**
 * 勘查问题标签
 * @author bcxin
 *
 */
@Entity
@Table(name = "RISK_SurveyTag")
@Proxy(proxyClass = SurveyTag.class)
@Inheritance(strategy = InheritanceType.JOINED)
@DynamicInsert(true)
@DynamicUpdate(true)
public class SurveyTag extends BaseBean{

	private static final long serialVersionUID = 1L;
		
	private String name;//标签名

	@Enumerated(EnumType.STRING)
	private TagType tagType;//标签类型
	
	private int level;//级别
	
	private long parentId;//上级标签Id
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public TagType getTagType() {
		return tagType;
	}

	public void setTagType(TagType tagType) {
		this.tagType = tagType;
	}

	public int getLevel() {
		return level;
	}

	public void setLevel(int level) {
		this.level = level;
	}

	public long getParentId() {
		return parentId;
	}

	public void setParentId(long parentId) {
		this.parentId = parentId;
	}
	
	
}
