package com.bcxin.survey.domain.survey;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import com.bcxin.survey.domain.BaseBean;

/**
 * 整改信息
 * @author Administrator
 *
 */
@Entity
@Table(name = "RISK_SurveyReform")
@Inheritance(strategy = InheritanceType.JOINED)
@Proxy(proxyClass = SurveyReform.class)
@DynamicInsert(true)
@DynamicUpdate(true)
public class SurveyReform extends BaseBean{

	private static final long	serialVersionUID	= 1L;

	private String result;//整改结果

	@OneToMany(targetEntity = Survey_Photo.class, cascade = CascadeType.REMOVE,mappedBy="correction")
    private List<Survey_Photo> correctionPhotos = new ArrayList<Survey_Photo>();

	public String getResult() {
		return result;
	}

	public void setResult(String result) {
		this.result = result;
	}

	public List<Survey_Photo> getCorrectionPhotos() {
		return correctionPhotos;
	}

	public void setCorrectionPhotos(List<Survey_Photo> correctionPhotos) {
		this.correctionPhotos = correctionPhotos;
	}
	
}
