package com.bcxin.survey.domain.security;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import com.bcxin.survey.domain.BaseBean;

import javax.persistence.*;

import java.util.Date;

@Entity
@Table(name = "RISK_SE_USER")
@Inheritance(strategy = InheritanceType.JOINED)
@DynamicInsert(true)
@DynamicUpdate(true)
public class User extends BaseBean {

	private static final long serialVersionUID = 1L;

	private String userName;
	
	private String realName;

	private String password;

	private String 	email; //邮箱

	private String 	phone; //手机

	private String orgAdmin;//是否是机构管理员；1代表是，0代表不是

	private String userType;//用户类型

	private String active ; //是否有效 0:无效，1:有效

	/**
	 * saas人员id
	 */
	private String perId;
	/** 找回密码 **/
	private String validateCode; //密钥
	
	@Temporal(TemporalType.TIMESTAMP)
	private Date overdueTime;  //过期时间

	@ManyToOne(targetEntity = Org.class, fetch = FetchType.EAGER)
	@JoinColumn(name = "org_id")
	private Org org; //所属机构
	/**
	 * 注册人ip
	 */
	private String ipAddress;

	@Transient
	private String allowMenus;

	private Long province_id ;//省份

	private Long city_id;// 城市

	private Long area_id;//区

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getRealName() {
		return realName;
	}

	public void setRealName(String realName) {
		this.realName = realName;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getOrgAdmin() {
		return orgAdmin;
	}

	public void setOrgAdmin(String orgAdmin) {
		this.orgAdmin = orgAdmin;
	}

	public String getUserType() {
		return userType;
	}

	public void setUserType(String userType) {
		this.userType = userType;
	}

	public String getActive() {
		return active;
	}

	public void setActive(String active) {
		this.active = active;
	}

	public String getValidateCode() {
		return validateCode;
	}

	public void setValidateCode(String validateCode) {
		this.validateCode = validateCode;
	}

	public Date getOverdueTime() {
		return overdueTime;
	}

	public void setOverdueTime(Date overdueTime) {
		this.overdueTime = overdueTime;
	}

	public Org getOrg() {
		return org;
	}

	public void setOrg(Org org) {
		this.org = org;
	}

	public String getIpAddress() {
		return ipAddress;
	}

	public void setIpAddress(String ipAddress) {
		this.ipAddress = ipAddress;
	}

	public String getAllowMenus() {
		return allowMenus;
	}

	public void setAllowMenus(String allowMenus) {
		this.allowMenus = allowMenus;
	}

	public Long getProvince_id() {
		return province_id;
	}

	public void setProvince_id(Long province_id) {
		this.province_id = province_id;
	}

	public Long getCity_id() {
		return city_id;
	}

	public void setCity_id(Long city_id) {
		this.city_id = city_id;
	}

	public Long getArea_id() {
		return area_id;
	}

	public void setArea_id(Long area_id) {
		this.area_id = area_id;
	}

	public String getPerId() {
		return perId;
	}

	public void setPerId(String perId) {
		this.perId = perId;
	}
}
