package com.bcxin.survey.domain.security;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 服务机构
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_ServiceOrg")
@Inheritance(strategy = InheritanceType.JOINED)
@DynamicInsert(true)
@DynamicUpdate(true)
public class ServiceOrg extends Org {

	private static final long serialVersionUID = 1L;

	private String logo;

	private String introduce; //介绍

	private String experts; //专家团队

	/** 目前针对类型为 风险评估商 的服务机构 */
	private String serviceMode;//1,自营；2,第三方

	private String serviceOrgType;//参考OrgTypeUtil

	private String contactName;

    private String experience;

	private String contactPhone;

	private String contactAddress;

	private String business_license_num;//营业执照号码

	private String business_license;//营业执照副本照片

	private String distributionOrg;//是否为分销商； 0为不是，1为是

	private String syncDistribution; //是否已同步分销商;  0为不是，1为是

}
