package com.bcxin.survey.domain.security;

import com.bcxin.survey.domain.BaseBean;
import com.bcxin.survey.domain.data.Region;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 机构的基类
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_Org")
@Inheritance(strategy = InheritanceType.JOINED)
@DynamicInsert(true)
@DynamicUpdate(true)
@Data
public class Org extends BaseBean{

	private static final long serialVersionUID = 1L;

	private String code; //代码

	private String name; //名称

	private String address;

	private String orgType;//机构类型（字典）

	@ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "province_id")
	private Region province ;//省份

	@ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "city_id")
	private Region city;// 城市

	@ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "area_id")
	private Region area;//区

	@ManyToOne(targetEntity = Org.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "parent_id")
	private Org parent;//上级机构


}
