package com.bcxin.survey.domain.order;

import com.bcxin.survey.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 共享专家订单
 */
@Entity
@Table(name = "risk_expertorderform_public")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicUpdate(true)
@DynamicInsert(true)
public class ExpertOrderPublic extends BaseBean {

    private Long activityId;
    private Long orgId;
    private Long reportId;
    private Long taskId;
    private String orderNo;
    private String taskType;
    private Long userId;
    private String taskQuote;
    private String taskStatus;
    private String expertSource;
}
