package com.bcxin.survey.domain.data;

import com.bcxin.survey.domain.BaseBean;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 同步任务
* 记录每次与第三方系统的同步任务，如果没有同步，则需要定时任务进行同步
* @Description: 
* @date: 2018年05月17日 上午11:10:51
* @author 罗鹏
 */
@Entity
@Table(name = "RISK_SyncTask")
@Inheritance(strategy = InheritanceType.JOINED)
@DynamicInsert(true)
@DynamicUpdate(true)
public class SyncTask extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**
	 * 活动编号
	 */
	private String activityNo;

	/**
	 * 同步类型（字典）
	 */
	private String syncTaskType;

	/**
	 * 同步状态是否成功
	 */
	private String success;

	/**
	 * 参数（JSON 字符串）
	 */
	private String param;


	public String getSyncTaskType() {
		return syncTaskType;
	}

	public void setSyncTaskType(String syncTaskType) {
		this.syncTaskType = syncTaskType;
	}

	public String getSuccess() {
		return success;
	}

	public void setSuccess(String success) {
		this.success = success;
	}

	public String getParam() {
		return param;
	}

	public void setParam(String param) {
		this.param = param;
	}

	public String getActivityNo() {
		return activityNo;
	}

	public void setActivityNo(String activityNo) {
		this.activityNo = activityNo;
	}
}
