package com.bcxin.survey.domain.activity;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import com.bcxin.survey.domain.BaseBean;
import com.bcxin.survey.domain.data.Region;

import javax.persistence.*;

/**
 * 场地表
 */
@Entity
@Table(name = "SYS_Venue")
@Inheritance(strategy = InheritanceType.JOINED)
@DynamicInsert(true)
@DynamicUpdate(true)
public class Venue extends BaseBean {

	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "province_id")
	private Region province ;//省份

	@ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "city_id")
	private Region city;// 城市

	@ManyToOne(targetEntity = Region.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "area_id")
	private Region area;//区

	private String name;

	private String address;

	private String toid; //第三方的id

	private String standard;//是否为已录入的标准场馆，0为不是，1为是

	public Region getProvince() {
		return province;
	}

	public void setProvince(Region province) {
		this.province = province;
	}

	public Region getCity() {
		return city;
	}

	public void setCity(Region city) {
		this.city = city;
	}

	public Region getArea() {
		return area;
	}

	public void setArea(Region area) {
		this.area = area;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getToid() {
		return toid;
	}

	public void setToid(String toid) {
		this.toid = toid;
	}

	public String getStandard() {
		return standard;
	}

	public void setStandard(String standard) {
		this.standard = standard;
	}

	
}
