package com.bcxin.survey.dao.report;

import com.bcxin.survey.domain.report.Task;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.dto.TaskDetailVo;
import com.bcxin.survey.dto.TaskSearchDto;
import com.bcxin.survey.enums.report.SurveyStep;
import com.bcxin.survey.vo.DwzPage;

import java.util.List;
import java.util.Map;

public interface TaskDao extends BaseDao {

	List<Task> findTaskList(User user ,DwzPage page) ;
	
	Task findTaskByOid(long oid) ;

    List<TaskDetailVo> findSurveyTaskListForPage(TaskSearchDto searchDto, DwzPage page);

	List<TaskDetailVo> findTaskListByOvertime3Hour(Long orgId);

	List<Task> selectTaskBysurveryTaskId(Long oid);

	User selectExpertBySurveyTaskId(long taskId);

	List<Map<String,Object>> selectExpertBySurveyTaskIdList(StringBuilder taskIdList);

	Integer selectStepExpert(Long taskId);

	String selectStepExpertName(Long taskId);
	String selectStepExpertName(Long taskId,String surveyStep);

	/**
	 * 获取专家申请界面的踏勘阶段
	 * @param taskId
	 * @return
	 */
	List<SurveyStep> selectApplyExpertStep(Long taskId);
}
