package com.bcxin.survey.dao.report;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import com.bcxin.survey.domain.data.Region;
import com.bcxin.survey.utils.StringUtil;

/**
 * 一些基础查询 
 * @author admin
 *
 */
@Repository("dataDao")
@SuppressWarnings("unchecked")
public class DataDaoImpl extends BaseDaoImpl implements DataDao {

	//------------------------【城市Region】-----------------------------
	
	@Override
	public List<Region> findRegionByLevel(String level) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		
		if (StringUtil.isNotEmpty(level)) {
			criterionList.add(Restrictions.eq("level", level));
		} 
		
		return findByCriterion(Region.class,criterionList,Order.desc("orderNum"));
	}

	@Override
	public List<Region> findRegionByParent(String parentCode) {
	
		List<Criterion> criterionList = new ArrayList<Criterion>();
		
		if(StringUtil.isNotEmpty(parentCode)) {
			criterionList.add(Restrictions.eq("parentCode", parentCode));
		}
		
		return 	findByCriterion(Region.class, criterionList,Order.desc("orderNum"));
	}

	@Override
	public Region findRegionByCode(String code) {
		return findByCriterionToUnique(Region.class, Restrictions.eq("code", code));
	}
	

	@Override
	public List<Region> findRegionByParent(String codeLevel, String parentCode) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		
		if(StringUtil.isNotEmpty(parentCode)) {
			criterionList.add(Restrictions.eq("parentCode", parentCode));
		}
		if(StringUtil.isNotEmpty(codeLevel)) {
			criterionList.add(Restrictions.eq("level", codeLevel));
		}
		
		
		return 	findByCriterion(Region.class, criterionList,Order.desc("orderNum"));
	}
	//------------------------【天气Weather】-----------------------------

}
