package com.bcxin.survey.dao.report;

import com.bcxin.survey.vo.DwzPage;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.type.Type;
import org.springframework.dao.DataAccessException;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 基础类dao
 * @author admin
 *
 */
public interface BaseDao {

	public abstract Criteria createCriteria(Class clazz);

	public abstract <T> T get(Class<T> clazz, Long oid);
	
	public abstract <T> T load(Class<T> clazz, Long oid);

	public abstract void save(Object obj);
	
	public boolean batchSave(List<Object> list);

	public abstract void update(Object obj);
	
	public abstract void saveOrUpdate(Object obj);

	public abstract void delete(Object obj);

	public abstract <T> List findAll(Class<T> clazz);

	public abstract <T> List findByCriterion(Class<T> clazz, Criterion criterion);

	public abstract List findByHql(String queryString, Object value)
			throws DataAccessException;

	public abstract <T> List findByHql(String queryString, Object[] values);

	public abstract List findByHql(String queryString)
			throws DataAccessException;

	public <T>T findByCriterionToUnique(Class<T> clazz,Criterion criterion);
	
	public List find(String queryString,Map paras);
	
	public List findPageByHql(String queryString,Map paras,DwzPage page);
	
	public List getObejctByCollection(String queryString,String name,Collection collection);
	
	public List getObejctByCollection(String queryString,String name,Collection collection,Type type);
	
	public <T>List findByCriterionForPage(Class<T> clazz, List<Criterion> criterionList, DwzPage page);

	public <T>List findByCriterionForPage(Class<T> clazz, List<Criterion> criterionList, DwzPage page, Order order);
	
	public <T>List findByCriterionForPage(Class<T> clazz, List<Criterion> criterionList, DwzPage page, List<Order> orderList);
	
	public <T>List findByCriterion(Class<T> clazz, List<Criterion> criterionList);
	
	public <T>List findByCriterion(Class<T> clazz, List<Criterion> criterionList, List<Order> orderList);
	
	public <T>List findByCriterion(Class<T> clazz, List<Criterion> criterionList, Order order);
	
	public int executeUpdate(final String sql);
	
	public List findBySQL(String sql, final Object[] values);

	public Integer findCountBySQL(String sql, final Object[] values);
	
	public void evictObj(Object obj);
	
	public void mergeObj(Object obj);
	
	public <T>List findByCriterionForPage(Class<T> clazz, List<Criterion> criterionList, int pagesize, int offset);
	
	public <T>List findByCriterionForPage(Class<T> clazz, List<Criterion> criterionList, int pagesize, int offset, Order order);

	public Integer getCount(String queryString,Map paras);
}