package com.bcxin.survey.dao.report;

import com.bcxin.survey.domain.activity.Activity;
import com.bcxin.survey.dto.ActivityCooperDTO;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * 状态表数据类
 * @author Ethan
 */
@Repository
public class ActivityCooperDaoImpl extends BaseDaoImpl implements ActivityCooperDao{

    @Override
    public List<ActivityCooperDTO> findActivityCooperDtoByActivty(Activity activity){
        StringBuffer sql = new StringBuffer("select o.oid,o.name,so.serviceOrgType,so.contactPhone," +
                "so.contactName ,rcp.amount,so.serviceMode,rcp.oid as rcpoid,so.financePhone," +
                " so.distributionorg as distributionorg ,a.oid AS orderId,o.oid AS orgId " +
                " from RISK_ACTIVITY_COOPER rcp " +
                " inner join RISK_ACTIVITY r on r.oid = rcp.activity_id " +
                " inner join RISK_ORG o on o.oid = rcp.org_Id " +
                " inner join RISK_ORDERFORM a on a.activity_id = r.oid " +
                " inner join RISK_SERVICEORG so on so.oid = o.oid where 1=1 ");

        if ( activity == null ) {
            return Lists.newArrayList();
        } else {
            sql.append(" and r.oid="+activity.getOid());
        }
        List<ActivityCooperDTO> dtoList = Lists.newArrayList();
        List<Map<String,Object>> list = this.findBySQL(sql.toString(),null);
        list.forEach(result->{
            Map<String,Object> map = (Map<String,Object>)result;
            ActivityCooperDTO dto = new ActivityCooperDTO(map);
            dtoList.add(dto);
        });
        return dtoList;
    }
}