package com.bcxin.survey.dao.log;

import com.bcxin.survey.dao.report.BaseDaoImpl;
import com.bcxin.survey.domain.log.SysLog;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.io.ByteArrayOutputStream;
import java.util.Date;

/**
 * @author hzp
 */
@Repository("sysLogDao")
public class SysLogDaoImpl extends BaseDaoImpl implements SysLogDao {

    @Override
    public void saveLog(SysLog sysLog){
        this.save(sysLog);
    }

    @Override
    public void saveLog(String method,String content,boolean isFail){
        try {
            SysLog log=new SysLog();
            log.setCreateOn(new Date());
            log.setMethod(method);
            if(isFail) {
                log.setLogType("0");
                log.setContent("踏勘系统异常");
                log.setException(content);
            }else{
                log.setLogType("1");
                log.setContent("踏勘系统:"+content);
            }
            this.save(log);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    @Override
    public void saveLog(String method,String content,Exception e){
        try {
            SysLog log=new SysLog();
            log.setCreateOn(new Date());
            log.setMethod(method);
            log.setLogType("0");
            log.setContent("踏勘系统异常:"+content);
            log.setException(getStackMessage(e));
            this.save(log);
        }catch (Exception ex){
            ex.printStackTrace();
        }
    }

    /**
     * 获取异常堆栈信息
     * @param e
     * @return
     */
    public String getStackMessage(Exception e){
        ByteArrayOutputStream buf = new java.io.ByteArrayOutputStream();
        try {
            e.printStackTrace(new java.io.PrintWriter(buf, true));
            String expMessage = buf.toString();
            return expMessage;
        }catch (Exception ex){
            return "";
        }finally {
            try {
                buf.close();
            }catch (Exception ex1){

            }
        }
    }
}
