package com.bcxin.survey.controller.wechat;

import com.bcxin.survey.base.BaseController;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.venue.VenueBase;
import com.bcxin.survey.dto.AjaxResult;
import com.bcxin.survey.dto.ComposeVenueSearchDto;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.service.venue.ComposeVenueManageService;
import com.bcxin.survey.service.wechat.AccessTokenService;
import com.bcxin.survey.vo.DwzPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;

/**
 * 场馆维护
 * @author Administrator
 *
 */
@Controller
@RequestMapping("/wechat/venue")
public class WechatVenueController extends BaseController {

	@Autowired
	private UserService userService;

	@Autowired
	private AccessTokenService accessTokenService;

	@Autowired
	private ComposeVenueManageService composeVenueService;
	/**
	 * 检查用户(每个方法执行前被执行)
	 * @param request
	 * @param model
	 * @return
	 */
//	@ModelAttribute("errorView")
//	public ModelAndView getUser(HttpServletRequest request,Model model) {
//		ModelAndView view = new ModelAndView("");
//		userService.findUserByCode(request,view);
//		return view;
//	}
	
	/**
	 * 新增场馆 初始化进入
	 * @param request
	 * @return
	 */
	@RequestMapping("/addVenue/init")
	public ModelAndView addVenueInit(HttpServletRequest request){
		ModelAndView view = new ModelAndView("wechat/venue/addVenue");
		User user = (User) userService.getCurrentUser();
		view.addObject("user",user);
		return view;
	}

	/**
	 * 根据场馆类型获取场馆字段信息
	 * @param venueType
	 * @return
	 */
	@RequestMapping("/addVenue")
	public ModelAndView getInputsByVenueType(String venueType,HttpServletRequest request){
		ModelAndView view = new ModelAndView("wechat/venue/editVenue");
		view.addObject("venueList",composeVenueService.getVenueInputsByVenueType(venueType));
		view.addObject("venueType",venueType);

		ComposeVenueSearchDto searchDto = new ComposeVenueSearchDto();
		searchDto.setVenueType("2");
		searchDto.setNature("0");
		view.addObject("exhibitionList",composeVenueService.getVenueByType(searchDto));
//		accessTokenService.getJsApiConfig(view, request);
		return view;
	}

	/**
	 * 搜索场馆列表信息 初始化进入
	 * @param searchDto
	 * @param page
	 * @return
	 */
	@RequestMapping("/venueList/init")
	public ModelAndView venueListInit(ComposeVenueSearchDto searchDto, DwzPage page){
		ModelAndView view = new ModelAndView("wechat/venue/venueList");
		User user = userService.getCurrentUser();
		view.addObject("user",user);
		return view;
	}

	/**
	 * 查询场地列表
	 * @param searchDto
	 * @param page
	 * @return
	 */
	@RequestMapping("/venueListPaper")
	public @ResponseBody
	ComposeVenueSearchDto ruleListPaper(ComposeVenueSearchDto searchDto, DwzPage page){
		User user = userService.getCurrentUser();
		if (user != null) {
			searchDto.setData(composeVenueService.queryVenueList(searchDto,page));
			searchDto.setTotalCount((long) page.getTotalCount());
		}
		return searchDto;
	}

	/**
	 * 编辑场馆 初始化进入
	 * @param venueId
	 * @param request
	 * @return
	 */
	@RequestMapping("/editVenue")
	public ModelAndView editVenueInit(Long venueId,HttpServletRequest request){
		ModelAndView view = new ModelAndView("wechat/venue/editVenue");
		view.addObject("venueId",venueId);

		VenueBase venueBase = composeVenueService.findById(venueId);
		String venueType = venueBase.getVenueType();
		if(venueBase.getParentId() != null) {
			view.addObject("venue", composeVenueService.findById(venueBase.getParentId()));
		}
		view.addObject("venueList",composeVenueService.queryVenueListByVenueIdAndType(venueId,venueType));
		view.addObject("venueType",venueType);
		ComposeVenueSearchDto searchDto = new ComposeVenueSearchDto();
		searchDto.setVenueType("2");
		searchDto.setNature("0");
		view.addObject("exhibitionList",composeVenueService.getVenueByType(searchDto));
//		accessTokenService.getJsApiConfig(view, request);
		return view;
	}

	/**
	 *  保存修改的场馆信息
	 * @param request
	 * @return
	 */
	@RequestMapping("/saveVenue")
	public @ResponseBody AjaxResult saveVenue(VenueBase venueBase, HttpServletRequest request){
		//设置私有
		venueBase.setNature("0");
		return composeVenueService.saveOrUpdate(venueBase,request);
	}
}
