package com.bcxin.survey.controller.wechat;

import com.bcxin.survey.base.BaseController;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.SurveySign;
import com.bcxin.survey.domain.wechat.CheckCode;
import com.bcxin.survey.enums.report.EmailMsgType;
import com.bcxin.survey.service.NotifyService;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.service.wechat.AccessTokenService;
import com.bcxin.survey.service.wechat.CheckCodeService;
import com.bcxin.survey.service.wechat.SurveySignService;
import com.bcxin.survey.utils.*;
import com.bcxin.survey.vo.EmailModel;
import com.bcxin.survey.wechat.utils.WeixinUtil;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.Date;

@Controller
@RequestMapping("/wechat/user")
public class WechatUserController extends BaseController {

	@Autowired
	private UserService userService;
	
	@Autowired
	private CheckCodeService checkCodeService;
	
	@Autowired
	private AccessTokenService accessTokenService;
	
	@Autowired
	private SurveySignService surveySignService;
	
	@Autowired
	private NotifyService notifyService;

	@Resource
	private AuthenticationManager authenticationManager;

	@Autowired
	private BCryptPasswordEncoder bcryptEncoder;
	
	@org.springframework.web.bind.annotation.InitBinder
	public void InitBinder(WebDataBinder dataBinder) {
		dataBinder.registerCustomEditor(Date.class, new CustomDateEditor(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), true));  	
	}
	
	@RequestMapping("login/init")
	public ModelAndView loginInit(){
		ModelAndView view = new ModelAndView("wechat/user/login");
		return view;
	}
	
	@RequestMapping("doLogin")
	public JSONObject doLogin(User user,HttpServletRequest request){
		JSONObject json = new JSONObject();
		String message = "";
		String status= "300";
		User oldUser = userService.findUserByName(user.getUserName());
		if(oldUser != null){
			if(oldUser.getUserType().equals(DictConst.USERTYPE_DSFFWJGYH_TKQT)){
				if(bcryptEncoder.matches(user.getPassword(), oldUser.getPassword())){
					status="200";
					message ="登录成功！";
					userService.setAuthentication(oldUser.getUserName(), request );
				}
			}else{
				message="非勘查人员账户!";
			}
		}
		
		if(StringUtil.isEmpty(message)) {
			message = "用户名或者密码错误！";
		}
		
		json.put("message", message);
		json.put("status", status);
		return json;
	}

	@RequestMapping("jump/login")
	public ModelAndView jumpLogin(User user,HttpServletRequest request) throws Exception{
		//已注册
		UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken(Const.USER_ACCOUNT_KEY + user.getUserName(), BASE64Util.decryptBASE64("test"));
		authenticationToken.setDetails(new WebAuthenticationDetails(request));
		Authentication authenticatedUser = authenticationManager.authenticate(authenticationToken);
		SecurityContextHolder.getContext().setAuthentication(authenticatedUser);
		request.getSession().setAttribute(HttpSessionSecurityContextRepository.SPRING_SECURITY_CONTEXT_KEY, SecurityContextHolder.getContext());
		User currentUser = userService.getCurrentUser();
		/* 登录成功 */
		return new ModelAndView("redirect:/wechat/index");
	}

	/**
	 * 获取验证码
	 * @param request
	 * @return
	 */
	@RequestMapping("/getCheckCode")
	public JSONObject getCheckCode(HttpServletRequest request){
		String openId = request.getParameter("openId");
		String mobile= request.getParameter("mobile");
		String email= request.getParameter("email");
		String checkType= request.getParameter("checkType");
		String message = "";
		String status= "200";
		String userName = "";
		
		JSONObject json = new JSONObject();
		
		if(checkType.equals("EMAIL")){
			userName = email;
		}else{
			userName = mobile;
		}
		
		User user = userService.findUserByName(userName);
		if(user == null){
			status = "300";
			message = "不存在对应的勘察员！";
		}
		else{
			CheckCode checkCode = checkCodeService.getCheckCode(openId);
	
			if(checkCode != null){
				if(checkType.equals("MOBILE")){//手机验证方式
					notifyService.sendHuaWeiSMS(mobile,checkCode.getCode(), "BCXIN",DictConst.SMSCODE_P01,new String[]{checkCode.getCode()});
					checkCode.setMobile(mobile);
				} else if(checkType.equals("EMAIL")){//邮箱验证方式
					EmailModel model = new EmailModel();
					model.setEmailType(EmailMsgType.FORGETPASSWORD);
					model.setContent(checkCode.getCode());
					model.setTo(email);
					notifyService.sendEmail(model);
					checkCode.setEmail(email);
				}
				checkCodeService.saveOrUpdate(checkCode);
				message = "验证码发送成功！";
				json.put("requestId", checkCode.getRequestId());
			}else{
				message = "获取验证码失败！";
				status = "300";
			}
		}
		json.put("message", message);
		json.put("status", status);
		
		return json;		
	}
	
	/**
	 * 用户签到 页面初始化
	 * @param request
	 * @return
	 */
	@RequestMapping("userSign/init")
	public ModelAndView userSignInit(HttpServletRequest request){
		ModelAndView view = new ModelAndView("wechat/user/userSign");
		User user = (User) userService.getCurrentUser();
		if(user == null){				
			view.setViewName("wechat/errorClose");
			view.addObject("message", "非勘查人员或者网络异常，请重新打开！");
		}else{
			String jsapi_ticket= accessTokenService.getJsapiTicket();
			//String url="http://justme070.xicp.net/wechat/test/getjssdk";
			//String url="http://192.168.10.29:8080/wechat/test/getjssdk";
			String url = request.getRequestURL().toString();
			String noncestr = StringUtil.randomString(16);
			String timestamp = String.valueOf(System.currentTimeMillis() / 1000);
			String sign = WeixinUtil.getJSSDKSign(jsapi_ticket, noncestr, timestamp, url);
			view.addObject("appid",GlobalResources.APPID);
			view.addObject("url",url);
			view.addObject("noncestr",noncestr);
			view.addObject("timestamp",timestamp);
			view.addObject("sign",sign);
			view.addObject("signDate",new Date());
		}
		return view;
	}
	/**
	 * 用户签到 业务处理
	 * @param surveySign
	 * @return
	 */
	@RequestMapping("userSign")
	public JSONObject userSign(SurveySign surveySign){
		JSONObject json = new JSONObject();
		String message = "";
		String status= "300";
		User user = userService.getCurrentUser();
		surveySign.setUser(user);
		surveySign.setCreateOn(new Date());
		surveySign.setSignDate(DateUtil.getDayStart(new Date()));
//		SurveySign oldSurveySign = surveySignService.findSurveySignByUserAndDate(user, surveySign.getSignDate());
//		if(oldSurveySign != null){
//			message="你今天已签到过了！";
//		}
		if(surveySignService.saveOrUpdate(surveySign)){
			message="成功签到！";
			status= "200";
		}else {
			message = "签到失败！";
		}
		json.put("message", message);
		json.put("status", status);
		return json;
	}
	
	/**
	 * 业务逻辑处理，验证码校验(图片验证码)
	 * @param captcha
	 * @param request
	 * @return
	 */
	@RequestMapping("/checkYzm")
	public JSONObject checkYzm(@RequestParam String captcha, HttpServletRequest request) {
		JSONObject json = new JSONObject();
		String status = "300";
		String sessionyanz = (String)request.getSession(true).getAttribute("yzkeyword"); 
		if(captcha.equals(sessionyanz)){ 
			status="200";
		} 
		json.put("status", status);
		return json;
	}
	
	@RequestMapping("logout")
	public ModelAndView logout(){
		ModelAndView view = new ModelAndView("wechat/user/logout");
		return view;
	}
}
