package com.bcxin.survey.controller.wechat;

import com.bcxin.survey.base.WeChatController;
import com.bcxin.survey.domain.activity.ActivityVenue;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.*;
import com.bcxin.survey.dto.BuildTestDto;
import com.bcxin.survey.enums.report.FeedBackStatusEnum;
import com.bcxin.survey.enums.report.QuestionType;
import com.bcxin.survey.enums.report.SurveyStep;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.service.report.ActivityService;
import com.bcxin.survey.service.wechat.*;
import com.bcxin.survey.utils.ReportUtil;
import com.bcxin.survey.utils.StringUtil;
import com.google.common.collect.Lists;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;

/**
 * pss勘查
 * @author bcxin
 *
 */
@Controller
@RequestMapping("/wechat/survey")
public class WechatSurveyController extends WeChatController {
	

	@Autowired
	private UserService userService;

	@Autowired
	private SurveyTaskService surveyTaskService;
		
	@Autowired
	private SurveyFeedBackService surveyFeedBackService;

	@Autowired
	private SurveyInfoService surveyInfoService;

	@Autowired
	private SurveyPhotoService surveyPhotoService;
	
	@Autowired
	private SurveyQuestionnaireService surveyQuestionnaireService;
	
	@Autowired
	private AccessTokenService accessTokenService;
	
	@Autowired
	private SurveyPlanService surveyPlanService;

	@Autowired
	private ActivityService activityService;

	@Autowired
	private SurveySignService surveySignService;

	@Autowired
	ReportUtil reportUtil;
	
	/**
	 * 现场勘查 页面初始化
	 * @param request
	 * @return
	 */
	@RequestMapping("siteSurvey/init")
	public ModelAndView siteSurveyInit(HttpServletRequest request){
		ModelAndView view = new ModelAndView("wechat/survey/siteSurvey");
		User user =  userService.getCurrentUser();
		if(user != null ){	
			view.addObject("user",user);
			List<SurveyTask> taskList = surveyTaskService.findUnFinishedSurveyTaskListByUser(user);
			view.addObject("taskList",taskList);
			
//			accessTokenService.getJsApiConfig(view, request);
		}
		return view;
	}
	
	/**
	 * 现场勘查 页面初始化
	 * @param request
	 * @return
	 */
	@RequestMapping("siteSurveyByPlanId/{planId}")
	public ModelAndView siteSurveyByPlanIdInit(@PathVariable long planId,HttpServletRequest request){
		ModelAndView view = new ModelAndView("wechat/survey/siteSurvey");
		User user = userService.getCurrentUser();
		if(user != null ){	
			view.addObject("user",user);
			List<SurveyTask> taskList = surveyTaskService.findUnFinishedSurveyTaskListByUser(user);
			view.addObject("taskList",taskList);
			SurveyPlan surveyPlan = surveyPlanService.findSurveyPlanByOid(planId);
			view.addObject("surveyPlan",surveyPlan);
			
//			accessTokenService.getJsApiConfig(view, request);
		}
		return view;
	}
	@RequestMapping("findSurveyQuestion")
	public ModelAndView findSurveyQuestionForsiteSurvey(long taskId ,int time,HttpServletRequest request){
		ModelAndView view = new ModelAndView("wechat/survey/siteSurveyDetail");
		SurveyPlan surveyPlan = surveyPlanService.findSurveyPlanByTaskIdAndTime(taskId, time);
		SurveySign surveySign = surveySignService.findSurveySignByPlanId(surveyPlan.getOid());
		if(surveySign != null) {
			surveyPlan.setSign(true);
		}
		
		boolean lastSurveyComplete = true;
		int thisStep = Integer.parseInt(surveyPlan.getSurveyStep().getValue());
		if(thisStep > 1){
			Survey_FeedBack feedBack= surveyFeedBackService.findSurveyFeedBackByTaskAndStep(surveyPlan.getFeedBack().getSurveyTask(), SurveyStep.convertValue((thisStep-1)+""));
			if(!feedBack.getTaskStatus().equals(FeedBackStatusEnum.COMPLETE)) {
				lastSurveyComplete = false;
			}
		}
		view.addObject("lastSurveyComplete",lastSurveyComplete);
		view.addObject("surveyPlan",surveyPlan);
		if(lastSurveyComplete){
			Survey_Questionnaire questionnaire = surveyPlan.getQuestionnaire();
			view.addObject("questionnaire",questionnaire);
		}

		return view;
	}
	

	@RequestMapping("editAnswer/init")
	public ModelAndView editAnswerInit(int questionIndex,long questionId,HttpServletRequest request){
		ModelAndView view = new ModelAndView("wechat/survey/editAnswer");
		Survey_Info question = surveyInfoService.findSurveyInfoByOid(questionId);
		if(question != null && question.getQuestionType().equals(QuestionType.CARRYOVER)){
			Survey_Info oldQuestion = surveyInfoService.findSurveyInfoByOid(Long.parseLong(question.getLastSurveyInfoId()));
			question.setLastSurvey(oldQuestion);
		}
		view.addObject("questionIndex",questionIndex);
		view.addObject("question",question);
		return view;
	}
	
	@RequestMapping("saveSurveyQuestion")
    @ResponseBody
	public JSONObject saveSurveyQuestion(Survey_Info question,String[] mediaIds,HttpServletRequest request){
		JSONObject json = new JSONObject();
		String message ="";
		String status="300";
		String needReform = request.getParameter("needReform");
		Survey_Info oldQuestion;
		if(question.getOid() == null){
			oldQuestion = new Survey_Info();
			oldQuestion.setCreateOn(new Date());
			oldQuestion.setQuestion(question.getQuestion());
			oldQuestion.setAnswer(StringUtil.deleteAllCRLF(question.getAnswer()));
			oldQuestion.setQuestionType(QuestionType.SUPPLEMENT);
			oldQuestion.setQuestionnaire(question.getQuestionnaire());
			oldQuestion.setSort(question.getSort());
			surveyInfoService.saveOrUpdate(oldQuestion);
			json.put("questionId", oldQuestion.getOid());
		} else {
			oldQuestion = surveyInfoService.findSurveyInfoByOid(question.getOid());
		}
		oldQuestion.setReplied(true);
		if(StringUtil.isNotEmpty(question.getAnswer())) {
			oldQuestion.setAnswer(StringUtil.deleteAllCRLF(question.getAnswer()));
		}
		if(StringUtil.isNotEmpty(needReform) && needReform.equals("1")) {
			oldQuestion.setNextSurvey(true);
		} else {
			oldQuestion.setNextSurvey(false);
		}
		
		if(mediaIds != null && mediaIds.length > 0){
			Survey_Info surveyInfo = surveyInfoService.findSurveyInfoByOid(oldQuestion.getOid());
			for (String mediaId : mediaIds) {
				surveyFeedBackService.uploadSurveyImg(mediaId,surveyInfo,request);
			}
		}
		String delPhotoIds = request.getParameter("delPhotoIds");
		if(StringUtil.isNotEmpty(delPhotoIds)){
			List<Long> idList = Lists.newArrayList();
			for(String photoId:delPhotoIds.split("#")){
				if(StringUtil.isNotEmpty(photoId)){
					idList.add(Long.parseLong(photoId));
				}
			}
			surveyPhotoService.deleteAllSurveyPhotoByOidList(idList);
		}
		if(surveyInfoService.saveOrUpdate(oldQuestion)){
			message ="保存成功";
			status="200";
		} else {
			message = "保存失败";
		}
		json.put("message", message);
		json.put("status", status);
		return json;
	}

	@RequestMapping("uploadPhotosFile")
    @ResponseBody
	public JSONObject uploadPhotosFile(@RequestParam(value = "photos", required = false) MultipartFile photos, HttpServletRequest request){// HttpServletRequest request
		JSONObject json = new JSONObject();
		String message ="";
		String status="300";
		String randNum = request.getParameter("randNum");
		String serverId = randNum+System.currentTimeMillis()+"";
		String path= "answer/"+serverId;
		String url = surveyFeedBackService.generateImageFile(photos,path,request);
		if(StringUtil.isEmpty(url)){
			message = "文件保存失败";
			json.put("message", message);
			json.put("status", status);
			return json;
		}
		JSONObject ret = new JSONObject();
		ret.put("photos", url);
		ret.put("serverId", serverId);
		request.getSession().setAttribute(serverId,url);
		message ="保存成功";
		status="200";
		json.put("message", message);
		json.put("status", status);
		json.put("data", ret);
		return json;
	}

	@RequestMapping("siteSurveyView/{planId}")
	public ModelAndView siteSurveyView(@PathVariable long planId,HttpServletRequest request){
		ModelAndView view = new ModelAndView("wechat/survey/siteSurveyView");
		SurveyPlan surveyPlan = surveyPlanService.findSurveyPlanByOid(planId);
		Survey_Questionnaire questionnaire = surveyQuestionnaireService.findQuestionnaireByOid(surveyPlan.getQuestionnaire().getOid());
		List<Survey_Info> surveyInfoList = questionnaire.getSurveyInfos();
		for (Survey_Info survey_Info : surveyInfoList) {
			if(StringUtil.isNotEmpty(survey_Info.getLastSurveyInfoId())) {
				survey_Info.setLastSurvey(surveyInfoService.findSurveyInfoByOid(Long.parseLong(survey_Info.getLastSurveyInfoId())));
			}
		}
		view.addObject("surveyPlan",surveyPlan);
		view.addObject("questionnaire",questionnaire);
		view.addObject("surveyInfoList",questionnaire.getSurveyInfos());
		
//		accessTokenService.getJsApiConfig(view, request);
		
		return view;
	}
	
	@RequestMapping("removeQuestion")
    @ResponseBody
	public JSONObject removeQuestion(long questionId,HttpServletRequest request){
		JSONObject json = new JSONObject();
		String message = "";
		String status ="300";
		Survey_Info question = surveyInfoService.findSurveyInfoByOid(questionId);
		if(surveyInfoService.delete(question)){
			message = "成功移除！";
			status ="200";
		}else{
			message = "移除失败！";
		}
		json.put("message", message);
		json.put("status", status);
		return json;
	}
	
	@RequestMapping("showSign")
	public ModelAndView showSign(){
		return new ModelAndView("/wechat/survey/siteSurveyDialog");
	}
	
	@RequestMapping("finishSurvey")
	@ResponseBody
	public JSONObject finishSurvey(HttpServletRequest request){
//		JSONObject json = surveyFeedBackService.finishSurvey(request);
		JSONObject json = surveyFeedBackService.finishSurveyNew(request);
		return json;
	}

	@RequestMapping("rebuildReport/{questionId}")
	@ResponseBody
	public String finishSurvey(@PathVariable("questionId") Long questionId){
		String surveyReport=reportUtil.createAndSaveSurveyReport(questionId);
		return surveyReport;
	}

	@RequestMapping("createSurveyReportTest")
	@ResponseBody
	public String createSurveyReportTest(@RequestBody BuildTestDto dto, HttpServletRequest request){
		return reportUtil.createSurveyReportTest(dto);
	}

	@RequestMapping("findCmsAddressListByTaskId")
    @ResponseBody
	public JSONObject findCmsAddressListByTaskId(long taskId){
		JSONObject json = new JSONObject();
		JSONArray addressArr = new  JSONArray();
		SurveyTask task = surveyTaskService.findSurveyTaskByOid(taskId);

		List<ActivityVenue> addressList = activityService.findActivityVenuesByActivity(task.getActivity());
		for (ActivityVenue address : addressList) {
			JSONObject obj = new JSONObject();
			obj.put("oid", address.getOid());
			obj.put("address", address.getVenue().getName());
			addressArr.add(obj);
		}
		String status = "200";
		json.put("status", status);
		json.put("cmsAddresss", addressArr);
		return json;
	}
	
	
	@RequestMapping("findSurveyStepByTaskIdAndTime")
    @ResponseBody
	public JSONObject findSurveyStepByTaskIdAndTime(long taskId, int time){
		JSONObject json = new JSONObject();
		SurveyPlan plan = surveyPlanService.findSurveyPlanByTaskIdAndTime(taskId,time);
		if(plan != null){
			json.put("surveyStep", plan.getSurveyStep().toString());
			json.put("stepName", plan.getSurveyStep().getName());
			json.put("cmsAddress", plan.getVenue().getName());
		}
		return json;
	}
}
