package com.bcxin.survey.controller;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.bcxin.survey.base.BaseController;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.utils.BASE64Util;
import com.bcxin.survey.utils.Const;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Optional;

@Controller
@RequestMapping("/communicate/v5")
@Slf4j
public class V5LoginController extends BaseController {
    private static final String SECRET_KEY = "teemlink_obpm";
    @Resource
    private AuthenticationManager authenticationManager;
    @Autowired
    private UserService userService;

    public static String getBcxToken(HttpServletRequest request) {
        return Optional.ofNullable(request.getHeader(Const.V5_TOKEN_KEY)).orElse(request.getParameter(Const.V5_TOKEN_KEY));
    }

    public static String getAccountFromBcxToken(String bcxToken) {
        try {
            JWTVerifier xxx = JWT.require(Algorithm.HMAC256(SECRET_KEY)).withIssuer("auth0").acceptExpiresAt(1000 * 1000).build();
            DecodedJWT jwt = xxx.verify(bcxToken);
            String account = jwt.getClaim("username").asString();
            return account;
        } catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        String bcxToken = "eyJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJhdXRoMCIsImV4cCI6MTcxMDczMjc0MiwidXNlcm5hbWUiOiJaMkVOTWp2UiJ9.6ay9uFkFMuzLgSYDrFR15CIvSn7iXkxVGvaAYu902ac";
        System.out.println(getAccountFromBcxToken(bcxToken));
    }

    @RequestMapping("/user/v5Login")
    public ModelAndView v5Login(HttpServletRequest request, HttpServletResponse response) {
        try {
            String accessToken = getBcxToken(request);
            String account = getAccountFromBcxToken(accessToken);

            UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken(Const.V5_ACCOUNT_KEY + account, BASE64Util.decryptBASE64(""));
            authenticationToken.setDetails(new WebAuthenticationDetails(request));
            Authentication authenticatedUser = authenticationManager.authenticate(authenticationToken);
            SecurityContextHolder.getContext().setAuthentication(authenticatedUser);
            request.getSession().setAttribute(HttpSessionSecurityContextRepository.SPRING_SECURITY_CONTEXT_KEY, SecurityContextHolder.getContext());

            User user = userService.getCurrentUser();
            /* 登录成功 */
            return new ModelAndView("redirect:/wechat/index");
        } catch (Exception e) {
            return new ModelAndView("/wechat/errorAuth").addObject("msg", e.getMessage());
        }
    }

    @RequestMapping("/user/loading")
    public ModelAndView v5Loading(HttpServletRequest request) throws Exception {
        String accessToken = getBcxToken(request);
        ModelAndView view = new ModelAndView("/v5/loading");
        view.addObject("accessToken", accessToken);
        return view;
    }
}
