package com.bcxin.survey.controller;

import com.bcxin.survey.base.BaseController;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.utils.ConfigUtil;
import com.bcxin.survey.utils.FileUtils;
import com.bcxin.survey.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Controller
public class IndexController extends BaseController {

	@Autowired
	private UserService userService;
	@RequestMapping("wechat/index")
	public ModelAndView index(HttpServletRequest request){
		String check = request.getParameter("_check");
		User currentUser = userService.getCurrentUser();
		ModelAndView view = new ModelAndView("/wechat/index");
		view.addObject("currentUser", currentUser);
		view.addObject("check", check);
		return view;
	}
	
	@RequestMapping( value={"manage/login","","/"})
	public ModelAndView initLogin() {
		ModelAndView view = new ModelAndView("/manage/login");
		return view;
	}
	
	@RequestMapping("manage/index")
	public ModelAndView initIndex() {
		ModelAndView view = new ModelAndView("/manage/index");
		return view;
	}

	@RequestMapping(value = "/getResource")
	public void getResource(String path, HttpServletResponse response) {
		String upload_path = ConfigUtil.material();
		FileUtils.downloadAllFile(path, response, upload_path);
	}

	@RequestMapping(value = "/getResourceFullPath")
	public void getResourceFullPath(String fullPath, HttpServletResponse response) {
		FileUtils.downloadAllFile(fullPath, response,"");
	}

}
