package com.bcxin.survey.communicate.sb;

import com.alibaba.fastjson.JSON;
import com.bcxin.survey.dao.report.SyncTaskDao;
import com.bcxin.survey.dto.SBDataDTO;
import com.bcxin.survey.utils.*;
import com.google.common.collect.Lists;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.Future;

/**
 * 与申报子系统对接的所有业务
 */
@Service("sbRspService")
@Transactional
public class SBRspServiceImpl implements SBRspService {

    private static final String SYNCFILE_API = "/communicate/sb/file/syncFile";

    private static final String SURVEYREPORT_API = "/communicate/sb/survey/report/sync";

    private static final String SYNCACTID_API = "/communicate/sb/activity/oid/get";


    @Resource
    private SyncTaskDao syncTaskDao;

    /**
     * 与申报子系统接口同步
     */
    @Override
    @Async
    public Future<Boolean> sbAsync(SBDataDTO sbDataDTO){
        String requestUrl = sbDataDTO.getChannel();
        /* 勘查报告同步 */
        if (DictConst.SYNCTASKTYPE_TKBG.equals(sbDataDTO.getSyncTaskType())) {
            requestUrl = requestUrl + SURVEYREPORT_API;
        }
        /* 传文件 */
        else if (DictConst.SYNCTASKTYPE_FILE.equals(sbDataDTO.getSyncTaskType())) {
            requestUrl = requestUrl + SYNCFILE_API;
        }
        //用json传，用json解
        List<NameValuePair> params = Lists.newArrayList();
        params.add(new BasicNameValuePair("dataDTO", JSON.toJSONString(sbDataDTO)));
        params.add(new BasicNameValuePair("sign", MD5Util.string2MD5(Const.ENVI + DateUtil.getCurrentDate())));
        String status = HttpUtil.sendPostRequest(requestUrl,params);
        if (DictConst.Y.equals(status)) { //成功
            if (sbDataDTO.getTask() == null) {
                return new AsyncResult<Boolean>(true);
            }
            sbDataDTO.getTask().setSuccess(DictConst.Y);
            syncTaskDao.saveOrUpdate(sbDataDTO.getTask());
            return new AsyncResult<Boolean>(true);
        }
        return new AsyncResult<Boolean>(false);
    }


    /**
     * 获得子站的活动id
     */
    @Override
    public String activityIdGet(SBDataDTO sbDataDTO){
        String requestUrl = sbDataDTO.getChannel();
        /* 获得子站的活动id */
        if (DictConst.SYNCTASKTYPE_ACTID.equals(sbDataDTO.getSyncTaskType())) {
            requestUrl = requestUrl + SYNCACTID_API;
        }
        //用json传，用json解
        List<NameValuePair> params = Lists.newArrayList();
        params.add(new BasicNameValuePair("dataDTO", JSON.toJSONString(sbDataDTO)));
        params.add(new BasicNameValuePair("sign", MD5Util.string2MD5(Const.ENVI + DateUtil.getCurrentDate())));
        String activityId = HttpUtil.sendPostRequest(requestUrl,params);
        return activityId;
    }

}
