package com.bcxin.survey.base;

import com.alibaba.fastjson.JSON;
import com.bcxin.survey.domain.log.SysLog;
import com.bcxin.survey.dto.AjaxResult;
import com.bcxin.survey.service.log.SysLogService;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Map;

/**
 * Controller 基类
 */
@Controller
public class WeChatController {

    @Autowired
    private HttpServletRequest request;
    @Autowired
    private SysLogService sysLogService;

    @ExceptionHandler({Exception.class})
    public Object exception(Exception e) {
        JSONObject json = new JSONObject();
        // 异步保存日志
        saveLog(e);
        // 如果是ajax请求
        if(isAjaxRequest(request)){
            String message =e.getMessage();
            String status="300";
            json.put("message", message);
            json.put("status", status);
            return json;
        }else{
            ModelAndView view = new ModelAndView("/error");
            view.addObject("msg",getStackMessage(e));
            return view;
        }
    }

    /**
     * 保存日志
     * @param e
     */
    public void saveLog(Exception e){
        String ip=getHost(request);
        String uri=request.getRequestURI();
        String userAgent=request.getHeader("user-agent");
        String paramJson=getRquestParamJson();
        String method=request.getMethod();
        //保存到日志到记录表中
        SysLog log = new SysLog();
        if(e!=null){
            log.setCreateOn(new Date());
            log.setIp(ip);
            log.setReqParam(paramJson);
            log.setUrl(uri);
            log.setUserAgent(userAgent);
            log.setMethod(method);
            log.setLogType("0");
            log.setContent("[WeChatController]踏勘系统异常");
            log.setException(getStackMessage(e));
            sysLogService.saveLog(log);
        }
    }

    /**
     * 获取异常堆栈信息
     * @param e
     * @return
     */
    public String getStackMessage(Exception e){
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            e.printStackTrace(new java.io.PrintWriter(buf, true));
            String expMessage = buf.toString();
            return expMessage;
        }catch (Exception ex){
            return "";
        }finally {
            try {
                buf.close();
            }catch (Exception ex1){

            }
        }
    }

    /**
     * 获取请求参数
     * @return
     */
    public String getRquestParamJson(){
        Map<String, String[]> param=request.getParameterMap();
        return JSON.toJSON(param).toString();
    }

    /** 获取客户端IP */
    public String getHost(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if ("127.0.0.1".equals(ip)) {
            InetAddress inet = null;
            try { // 根据网卡取本机配置的IP
                inet = InetAddress.getLocalHost();
            } catch (UnknownHostException e) {
                e.printStackTrace();
            }
            ip = inet.getHostAddress();
        }
        // 对于通过多个代理的情况，第一个IP为客户端真实IP,多个IP按照','分割
        if (ip != null && ip.length() > 15) {
            if (ip.indexOf(",") > 0) {
                ip = ip.substring(0, ip.indexOf(","));
            }
        }
        return ip;
    }

    /**
     * 判断是否ajax请求
     * @param request
     * @return
     */
    protected boolean isAjaxRequest(HttpServletRequest request) {
        String requestedWith = request.getHeader("X-Requested-With");
        return requestedWith != null ? "XMLHttpRequest".equals(requestedWith) : false;
    }
}
