// +----------------------------------------------------------------------
// | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
// +----------------------------------------------------------------------
// | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
// +----------------------------------------------------------------------
// | Author: CRMEB Team <admin@crmeb.com>
// +----------------------------------------------------------------------

import Layout from '@/layout';

const contentRouter = {
  path: '/community',
  component: Layout,
  redirect: '/community/classification',
  name: 'content',
  meta: {
    title: '社区',
    icon: 'clipboard',
  },
  children: [
    {
      path: 'classification',
      name: 'communityClassification',
      component: () => import('@/views/community/classification/index'),
      meta: {
        title: '社区分类',
        icon: 'clipboard',
      },
    },
    {
      path: 'topics',
      name: 'communityTopics',
      component: () => import('@/views/community/topics/index'),
      meta: {
        title: '社区话题',
        icon: 'clipboard',
      },
    },
    {
      path: 'content',
      name: 'communityContent',
      component: () => import('@/views/community/content/index'),
      meta: {
        title: '社区内容',
        icon: 'clipboard',
      },
    },
    {
      path: 'comments',
      name: 'communityComments',
      component: () => import('@/views/community/comments/index'),
      meta: {
        title: '社区评论',
        icon: 'clipboard',
      },
    },
    {
      path: 'config',
      name: 'communityConfig',
      component: () => import('@/views/community/config/index'),
      meta: {
        title: '社区配置',
        icon: 'clipboard',
      },
    },
  ],
};

export default contentRouter;
