const state = {
	token: null,
	forumToken: null,
	isLogin: false,
	userInfo: {},
	currentIndex: 0, // 客户管理底部导航index
	enterprise: {},
	uid: 0,
	loginBackUrl: '',
	homeActive: false,
	phoneStatus: true,
	depSelectPeople: [],
	isProcess: false,
	depSelectIds: [],
	depCheckIds: [],
	isOrgShow: false,
	frameTree: {},
	selectFrameTree: {},
	enterpriseAuth: {},
	scheduleMenuPermission: false,
	treeSelectBeforePage: '',
	customerFormType: {},
	codeSuccessKey: '',
	menus: [],
	oneOnOneData:{},
	isNoticeJumpPage: false, // 判断消息是否通过消息列表跳转页面
	depSelectIndex: -1, // 申请审批选中部门/成员
	depUserIndex: -1, // 申请流程中成员选择
	selectCustomUsers: [] // 自定义选择成员
}

const mutations = {
	init(state) {
		const tokenValue = uni.getStorageSync('storageTokenData')
		const userValue = uni.getStorageSync('storageUserData')
		const menuValue = uni.getStorageSync('storageMenuData')
		const forumData = uni.getStorageSync('storageForumData')
		const tree = uni.getStorageSync('storageFrameTree')
		if (forumData) {
			state.forumToken = forumData
		}
		if (tokenValue) {
			const data = JSON.parse(tokenValue)
			state.token = data.token
			state.isLogin = true
		}
		if (userValue) {
			const data = JSON.parse(userValue)
			state.userInfo = data.userInfo
			state.uid = data.userInfo.uid
			state.enterprise = data.enterprise
		}
		if (menuValue) {
			const data = JSON.parse(menuValue)
			state.menus = data.menu
		}
		if (tree) {
			state.frameTree = JSON.parse(tree)
		}
	},
	// 客户管理-底部导航高亮
	currentIndexFn(state, data) {
		state.currentIndex = data
	},
	// 登录
	login(state, data) {
		state.token = data.token
		state.isLogin = true
		uni.setStorageSync('storageTokenData', JSON.stringify(data))
	},
	// 登录用户信息
	loginInfo(state, data) {
		state.userInfo = data.userInfo
		state.uid = data.userInfo.uid
		state.enterprise = data.enterprise
		uni.setStorageSync('storageUserData', JSON.stringify(data))
	},
	// 登录用户菜单
	loginMenu(state, data) {
		state.menus = data.menus
		uni.setStorageSync('storageMenuData', JSON.stringify(data))
	},
	// 登录
	forumLogin(state, data) {
		state.forumToken = data
		uni.setStorageSync('storageForumData', data)
	},

	// 退出登录
	logout(state) {
		state.token = {}
		state.userInfo = {}
		state.enterprise = {}
		state.uid = 0
		state.isLogin = false
		state.frameTree = {}
		state.frameTree = []
		uni.removeStorageSync('storageUserData')
		uni.removeStorageSync('storageFrameTree')
	},
	frameTree(state, frameTree) {
		state.frameTree = frameTree
		uni.setStorageSync('storageFrameTree', JSON.stringify(frameTree))
	},
	//选择部门
	selectFrameTree(state, selectFrameTree) {
		state.selectFrameTree = selectFrameTree
	},
	setProcess(state, isProcess) {
		state.isProcess = isProcess
	},
	setoneOnOneData(state,one) {
		state.oneOnOneData = one
	},
	setLoginBackUrl(state, url) {
		state.loginBackUrl = url
	},
	setDepSelectPeople(state, depSelectPeople) {
		state.depSelectPeople = depSelectPeople
	},
	setDepSelectIds(state, depSelectIds) {
		state.depSelectIds = depSelectIds
	},
	setDepCheckIds(state, depCheckIds) {
		state.depCheckIds = depCheckIds
	},
	setIsOrgShow(state, isOrgShow) {
		state.isOrgShow = isOrgShow
	},
	setEnterpriseAuth(state, auth) {
		state.enterpriseAuth = auth
	},
	setScheduleMenuPermission(state, permission) {
		state.scheduleMenuPermission = permission
	},
	setTreeSelectBeforePage(state, page) {
		state.treeSelectBeforePage = page
	},
	setCustomerFormType(state, type) {
		state.customerFormType = type
	},
	setCodeSuccessKey(state, key) {
		state.codeSuccessKey = key
	},
	setiINoticeJumpPage(state, arg) {
		state.isNoticeJumpPage = arg
	},
	// 设置选中部门/成员
	setDepSelectIndex(state, arg) {
		state.depSelectIndex = arg
	},
	// 设置审批流程中选择成员
	setDepUserIndex(state, arg) {
		state.depUserIndex = arg
	},
	// 设置审批流程中选择成员
	setSelectCustomUsers(state, users) {
		state.selectCustomUsers = users
	}
}

const actions = {}

export default {
	state,
	mutations,
	actions
}