package com.bcxin.tenant.domain.utils;

import org.springframework.util.StringUtils;

public class OrganizationTypeUtils {
    public static String industryCodeOutOfName(String code){
        if(!StringUtils.hasLength(code)) {
            return "";
        }
        
        switch (code) {
            case "01":
                return "保安行业";
            case "02":
                return "大活行业";

            case "03":
                return "其他";

            case "04":
                return "内保行业";

            case "05":
                return "合作行业";

            case "06":
                return "群防群治行业";
            default:
                return "";
        }
    }

    public static String institutionalCodeOutOfName(String code){
        if(!StringUtils.hasLength(code)) {
            return "";
        }
        switch (code) {
            case "0101":
                return "保安协会";
            case "0102":
                return "保安服务公司";
            case "0103":
                return "保安培训单位";
            case "0104":
                return "自行招用保安员单位";
            case "0105":
                return "省级保安协会";
            case "0106":
                return "市级保安协会";
            case "0107":
                return "省级保安监管";
            case "0108":
                return "市级保安监管";
            case "0109":
                return "区县级保安监管";
            case "0110":
                return "派出所监管机构";
            case "0201":
                return "活动承办方";
            case "0202":
                return "政府单位";
            case "0203":
                return "风评机构";
            case "0204":
                return "服务机构";
            case "0205":
                return "公安机构";
            case "0207":
                return "省级大活监管";
            case "0208":
                return "市级大活监管";
            case "0209":
                return "区县级大活监管";
            case "0210":
                return "派出所监管机构";
            case "0211":
                return "活动运营方";
            case "0212":
                return "组委会";
            case "0214":
                return "体育局";
            case "0215":
                return "文旅局";
            case "0216":
                return "卫健委";
            case "0217":
                return "政法委";
            case "0218":
                return "共青团";
            case "0219":
                return "社团志愿者团队";
            case "0221":
                return "无人机反制公司";
            case "0222":
                return "医疗服务团队";
            case "0223":
                return "裁判服务团队";
            case "0301":
                return "其他";
            case "0302":
                return "培训机构会员单位";
            case "0401":
                return "医疗单位";
            case "0402":
                return "文博单位";
            case "0403":
                return "中小学、幼儿园";
            case "0404":
                return "高校";
            case "0405":
                return "金融单位";
            case "0406":
                return "党政机关";
            case "0407":
                return "省级内保监管";
            case "0408":
                return "市级内保监管";
            case "0409":
                return "区县级内保监管";
            case "0410":
                return "派出所监管机构";
            case "0501":
                return "渠道合作方";
            case "0502":
                return "供应商";
            case "0601":
                return "社区警务团队";
            case "0607":
                return "省级联防监管";
            case "0608":
                return "市级联防监管";
            case "0609":
                return "区县级联防监管";
            case "0610":
                return "派出所监管机构";
            default:
                return "";

        }
    }
}
