package com.bcxin.tenant.domain.services.impls;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.enums.InviteType;
import com.bcxin.Infrastructures.exceptions.ForbidTenantException;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.api.interfaces.tenants.responses.CompanyUSCCResponse;
import com.bcxin.api.interfaces.tenants.responses.TenantCompanyResponse;
import com.bcxin.tenant.domain.entities.InviteOrganizationRelationshipEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.repositories.InviteOrganizationRelationshipRepository;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import com.bcxin.tenant.domain.repositories.dtos.OrganizationDto;
import com.bcxin.tenant.domain.services.InviteOrganizationRelationshipService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.security.SecureRandom;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@Service
public class InviteOrganizationRelationshipServiceImpl implements InviteOrganizationRelationshipService {

    private final Logger logger = LoggerFactory.getLogger(InviteOrganizationRelationshipServiceImpl.class);

    private final InviteOrganizationRelationshipRepository inviteOrganizationRelationshipRepository;

    private final OrganizationRepository  organizationRepository;
    public InviteOrganizationRelationshipServiceImpl(InviteOrganizationRelationshipRepository inviteOrganizationRelationshipRepository, OrganizationRepository organizationRepository) {
        this.inviteOrganizationRelationshipRepository = inviteOrganizationRelationshipRepository;
        this.organizationRepository = organizationRepository;
    }

    @Override
    public String getGroupCode(String organizationId) {
        Collection<InviteOrganizationRelationshipEntity> inviteOrganizationRelationshipEntities =
                inviteOrganizationRelationshipRepository.findByOrganizationId(organizationId);
        if (inviteOrganizationRelationshipEntities != null && inviteOrganizationRelationshipEntities.size() > 0) {
            return inviteOrganizationRelationshipEntities.iterator().next().getCode();
        } else {
            TenantUserContext.UserModel currentUser = TenantContext.getInstance().getUserContext().get();
            if (currentUser == null) {
                throw new ForbidTenantException("必须有人来操作离职");
            }
            String code=UUIDUtil.getShortUuid();
            inviteOrganizationRelationshipRepository.save(InviteOrganizationRelationshipEntity.
                    create(code, organizationId, InviteType.GroupCode, "", currentUser.getId()));
            return code;
        }
    }

    @Override
    public CompanyUSCCResponse findCompanyUSCCByGroupCode(String groupCode) {
        Collection<InviteOrganizationRelationshipEntity> inviteOrganizationRelationshipEntities =
                inviteOrganizationRelationshipRepository.findByCode(groupCode);
        if (inviteOrganizationRelationshipEntities != null && inviteOrganizationRelationshipEntities.size() > 0) {
            String organizationId = inviteOrganizationRelationshipEntities.iterator().next().getOrganizationId();
            OrganizationDto dtoById = organizationRepository.getDtoById(organizationId);
            if (dtoById != null) {
                return CompanyUSCCResponse.create(dtoById.getName(),dtoById.getUnifySocialCreditCode());
            }
        }
        return null;
    }
}
