package com.bcxin.tenant.domain.repositories.dtos;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.bcxin.Infrastructures.enums.CredentialType;
import lombok.Data;

import java.util.Date;

@Data
public class LeaveEmployeeExport_06_Dto {

    @ExcelIgnore
    private String id;
    @ExcelProperty("姓名")
    private String name;
    @ExcelProperty("手机号")
    private String telephone;
    @ExcelProperty("原所在部门")
    private String departName;
    @ExcelProperty("证件类型")
    private String credentialTypeName;
    @ExcelIgnore
    private CredentialType credentialType;
    @ExcelProperty("证件号码")
    private String credentialNumber;

    @ExcelProperty("入职时间")
    @DateTimeFormat("yyyy-MM-dd")
    private Date hiredDate;
    @ExcelProperty("离职时间")
    @DateTimeFormat("yyyy-MM-dd")
    private Date leaveTime;
    @ExcelProperty("离职原因")
    private String leaveNote;
    @ExcelProperty("操作人")
    private String operatorName;
    @ExcelProperty("操作时间")
    @DateTimeFormat("yyyy-MM-dd HH:mm:ss")
    private Date createdTime;

}
