package com.bcxin.tenant.domain.repositories.dtos;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import lombok.Data;

import java.util.Date;

@Data
public class LeaveEmployeeExportDto {

    @ExcelIgnore
    private String id;
    @ExcelProperty("姓名")
    private String name;
    @ExcelProperty("手机号")
    private String telephone;
    @ExcelProperty("原所在部门")
    private String departName;
    @ExcelProperty("证件类型")
    private String credentialTypeName;
    @ExcelIgnore
    private CredentialType credentialType;
    @ExcelProperty("证件号码")
    private String credentialNumber;

    @ExcelProperty("是否投保")
    private String insure;

    @ExcelProperty("入职时间")
    @DateTimeFormat("yyyy-MM-dd")
    private Date hiredDate;
    @ExcelProperty("离职时间")
    @DateTimeFormat("yyyy-MM-dd")
    private Date leaveTime;
    @ExcelProperty("离职原因")
    private String leaveNote;
    @ExcelProperty("操作人")
    private String operatorName;
    @ExcelProperty("操作时间")
    @DateTimeFormat("yyyy-MM-dd HH:mm:ss")
    private Date createdTime;

    public LeaveEmployeeExportDto(String id, String name, String telephone,
                            TrueFalseStatus insure,
                            CredentialType credentialType,
                            String credentialNumber,
                                  Date hiredDate,
                                  Date leaveTime,
                            String leaveNote,String operatorName
            ,Date createdTime
    ) {
        this.id = id;
        this.name = name;
        this.telephone = telephone;
        this.credentialType = credentialType;
        this.credentialNumber = credentialNumber;
        this.hiredDate = hiredDate;
        this.leaveTime = leaveTime;
        this.leaveNote = leaveNote;
        this.createdTime =createdTime;
        this.operatorName = operatorName;
        if(insure != null){
            this.insure = insure.getTypeName();
        }else{
            this.insure = TrueFalseStatus.False.getTypeName();
        }

        if(credentialType != null){
            credentialTypeName = credentialType.getTypeName();
        }
    }

    public void assignDepart(String name) {
        this.departName = StrUtil.isEmpty(this.departName) ? name:this.departName+"、"+name;
    }
}
