package com.bcxin.tenant.domain.repositories.dtos;

import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.MemberType;
import com.bcxin.api.interfaces.enums.ExternalMemberInviteType;
import lombok.Getter;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

@Getter
public class ExternalMemberDTO {
    private final String id;

    private final ExternalMemberInviteType inviteType;

    private final String inviteCode;

    private final String tenantUserId;
    private final String tenantUserName;

    private final CredentialType credentialType;

    private final String credentialNumber;

    private final String telephone;

    private final ApprovedStatus approvedStatus;
    private final String approvedNote;

    private final String inviteGroupId;
    private final String inviteGroupName;

    private final Date createdTime;

    private Collection<String> principalGroupIds;

    private MemberType memberType;

    public ExternalMemberDTO(String id, ExternalMemberInviteType inviteType, String inviteCode, String tenantUserId, String tenantUserName,
                             String telephone,
                             CredentialType credentialType,
                             String credentialNumber,
                             ApprovedStatus approvedStatus, String approvedNote,
                             String inviteGroupId, String inviteGroupName, Date createdTime,
                             MemberType memberType) {
        this.id = id;
        this.inviteType = inviteType;
        this.inviteCode = inviteCode;
        this.tenantUserId = tenantUserId;
        this.tenantUserName = tenantUserName;
        this.telephone = telephone;
        this.credentialType = credentialType;
        this.credentialNumber = credentialNumber;
        this.approvedStatus = approvedStatus;
        this.approvedNote = approvedNote;
        this.inviteGroupId = inviteGroupId;
        this.inviteGroupName = inviteGroupName;
        this.createdTime = createdTime;
        this.principalGroupIds = new HashSet<>();
        this.memberType = memberType;
    }

    public void addPrincipalGroupIds(Collection<String> groupIds) {
        if (CollectionUtils.isEmpty(groupIds)) {
            this.principalGroupIds.clear();
        } else {
            this.principalGroupIds.addAll(groupIds);
        }
    }
}
