package com.bcxin.tenant.domain.repositories.composites;

import com.bcxin.tenant.domain.entities.ImportDataEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import lombok.Getter;

import java.io.Serializable;

@Getter
public class EmployeeImportWrapper implements Serializable {
    private final OrganizationEntity organization;
    private final ImportDataEntity importData;

    public EmployeeImportWrapper(OrganizationEntity organization, ImportDataEntity importData) {
        this.organization = organization;
        this.importData = importData;
    }

    public static EmployeeImportWrapper create(OrganizationEntity organization, ImportDataEntity importData) {
        return new EmployeeImportWrapper(organization, importData);
    }
}
