package com.bcxin.tenant.domain.repositories;

import com.bcxin.Infrastructures.EntityRepository;
import com.bcxin.Infrastructures.enums.RelationshipsStatus;
import com.bcxin.tenant.domain.entities.OrganizationRelationshipEntity;
import com.bcxin.tenant.domain.entities.OrganizationStatisticsReportEntity;
import com.bcxin.tenant.domain.repositories.dtos.OrgRelationDto;
import com.bcxin.tenant.domain.repositories.dtos.OrganizationRelationshipInfoDto;

import java.util.Collection;
import java.util.List;

public interface OrganizationRelationshipRepository extends EntityRepository<OrganizationRelationshipEntity,Long> {
    OrganizationRelationshipInfoDto getRelationshipDetailById(long id);

    OrganizationRelationshipEntity findById(long id);

    Collection<OrganizationRelationshipEntity> findByOrganizationIdAndSelectedOrganizationId(String organizationId, String selectedOrganizationId);

    Collection<OrganizationRelationshipInfoDto> getOrganizationRelationshipsInfo(String organizationId, Collection<RelationshipsStatus> Statuses);


    <S extends OrganizationRelationshipEntity> List<S> saveAll(Iterable<S> entities);

    List<OrganizationRelationshipEntity> findAllById(Iterable<Long> ids);

    Collection<OrgRelationDto> getParentList(String organizationId);

    Collection<OrgRelationDto> getChildrenList(String organizationId);
}
