package com.bcxin.tenant.domain.readers.dtos;

import com.bcxin.Infrastructures.enums.*;
import lombok.Getter;

import java.util.Collection;
import java.util.Date;

@Getter
public class MyOrganizationProfileDto {
    private final String id;
    private final String name;
    private final String industryCode;
    private final String institutionalCode;
    private final int organizationLevel;

    private final String orgCreatorUserId;

    /**
     * 职员的基本信息
     */
    private final String employeeId;
    private final OccupationType employeeOccupationType;
    private final EmploymentStatus employeeStatus;
    private final Date employeeHiredTime;
    private final String tenantUserId;
    private final MasterSlaveType masterSlaveType;
    private final boolean isDomainAdmin;
    private boolean isDepartAdmin;
    private final String areaCode;
    private final boolean hiredDatedLimited;
    private final boolean leaveDatedLimited;


    public MyOrganizationProfileDto(String id, String name, String industryCode, String institutionalCode, String areaCode,
                                    String orgCreatorUserId,
                                    String employeeId, String tenantUserId,
                                    OccupationType employeeOccupationType,
                                    EmploymentStatus employeeStatus, Date employeeHiredTime, MasterSlaveType masterSlaveType,
                                    TrueFalseStatus domainAdmin, int organizationLevel) {
        this.id = id;
        this.name = name;
        this.industryCode = industryCode;
        this.institutionalCode = institutionalCode;
        this.orgCreatorUserId = orgCreatorUserId;
        this.areaCode = areaCode;
        this.employeeId = employeeId;
        this.employeeOccupationType = employeeOccupationType;
        this.employeeStatus = employeeStatus;
        this.employeeHiredTime = employeeHiredTime;
        this.tenantUserId = tenantUserId;
        this.masterSlaveType = masterSlaveType;
        this.isDomainAdmin = domainAdmin == TrueFalseStatus.True;
        this.isDepartAdmin = domainAdmin == TrueFalseStatus.True;
        this.organizationLevel = organizationLevel;
        // 检查 institutionalCode 是否以 07、08、09、10 结尾，如果是则表示监管，不限制入职和离职日期
        if (institutionalCode != null && (institutionalCode.endsWith("07") || institutionalCode.endsWith("08") ||
                institutionalCode.endsWith("09") || institutionalCode.endsWith("10"))) {
            this.hiredDatedLimited = false;
            this.leaveDatedLimited = false;
        } else {
            this.hiredDatedLimited = true;
            this.leaveDatedLimited = true;
        }
    }

    public void setDepartAdmin(boolean departAdmin){
        this.isDepartAdmin = departAdmin;
    }
}
