package com.bcxin.tenant.domain.readers.dtos;

import com.bcxin.Infrastructures.enums.Sex;
import lombok.Getter;

import java.util.ArrayList;
import java.util.Collection;

@Getter
public class MyDepartImContactDto {
    private final String id;
    private final String name;
    private final String parentId;
    private final int displayOrder;
    private final Collection<ImContactItem> contacts;

    public MyDepartImContactDto(String id, String name, String parentId, int displayOrder) {
        this.id = id;
        this.name = name;
        this.parentId = parentId;
        this.displayOrder = displayOrder;
        this.contacts=new ArrayList<>();
    }

    public static MyDepartImContactDto create(String id, String name, String parentId, int displayOrder) {
        return new MyDepartImContactDto(id, name, parentId, displayOrder);
    }

    public void addContact(ImContactItem item) {
        this.contacts.add(item);
    }

    @Getter
    public static class ImContactItem {
        private final String id;
        private final String name;
        private final String headPhoto;
        private final String telephone;
        private final String imIdentity;
        private final Sex sex;

        public ImContactItem(String id, String name, Sex sex, String headPhoto, String telephone, String imIdentity) {
            this.id = id;
            this.name = name;
            this.headPhoto = headPhoto;
            this.telephone = telephone;
            this.imIdentity = imIdentity;
            this.sex = sex;
        }

        public static ImContactItem create(String id, String name, Sex sex, String headPhoto, String telephone, String imIdentity) {
            return new ImContactItem(id, name, sex, headPhoto, telephone, imIdentity);
        }
    }
}
