package com.bcxin.tenant.domain.readers.criterias;

import com.bcxin.Infrastructures.CriteriaAbstract;
import com.bcxin.Infrastructures.enums.ContractStatus;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.OccupationType;
import lombok.Getter;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import java.util.Collection;
import java.util.Date;
import java.util.List;

@Getter
public class EmployeeContractCriteria extends CriteriaAbstract {
    private final String keyword;
    private final String employeeId;


    private List<String> departIds;
    /**
     * 职业类型
     */
    private final Collection<OccupationType> occupationTypes;

    /**
     * 待入职，入职, 离职申请中，离职
     */
    @Enumerated(EnumType.ORDINAL)
    private final EmploymentStatus employmentStatus;
    private final Date beginDate;
    private final Date endDate;
    /**
     * 合同状态
     */
    private final ContractStatus status;
    /**
     * 开始创建日期
     */
    private final Date beginCreatedTime;
    /**
     * 结束创建日期
     */
    private final Date endCreatedTime;



    public EmployeeContractCriteria(int pageIndex, int pageSize, String keyword, String employeeId,
                                    List<String> departIds,Collection<OccupationType> occupationTypes,EmploymentStatus employmentStatus,Date beginDate,Date endDate,ContractStatus status,
                                    Date beginCreatedTime,
                                    Date endCreatedTime) {
        super(pageIndex, pageSize);
        this.keyword = keyword;
        this.employeeId = employeeId;
        this.departIds = departIds;
        this.occupationTypes = occupationTypes;
        this.employmentStatus = employmentStatus;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.status = status;
        this.beginCreatedTime = beginCreatedTime;
        this.endCreatedTime = endCreatedTime;
    }

    public static EmployeeContractCriteria create(int pageIndex, int pageSize, String keyword, String employeeId,
                                                  List<String> departIds,Collection<OccupationType> occupationTypes,EmploymentStatus employmentStatus,Date beginDate,Date endDate,ContractStatus status,
                                                  Date beginCreatedTime,
                                                  Date endCreatedTime) {
        return new EmployeeContractCriteria(pageIndex, pageSize, keyword, employeeId,
                departIds,occupationTypes,employmentStatus,beginDate,endDate,status,
                beginCreatedTime,
                endCreatedTime);
    }
}
