package com.bcxin.tenant.domain.events.handlers;

import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.tenant.domain.events.TenantCheckStatusChangedEvent;
import com.bcxin.tenant.domain.repositories.TenantUserRepository;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
public class TenantCheckStatusChangedEvent_Handler extends DomainEventHandlerAbstract<TenantCheckStatusChangedEvent>
{
    private final TenantUserRepository userRepository;

    public TenantCheckStatusChangedEvent_Handler(TenantUserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Override
    protected void execute(TenantCheckStatusChangedEvent event) {
        if (StringUtils.hasLength(event.getIdCardNum())) {
            Collection<String> idCardNums = Stream.of(event.getIdCardNum()).collect(Collectors.toList());
            this.userRepository.updateCredentialDetailsTenantUserId(
                    idCardNums,
                    event.getData().getId()
            );
        }
    }
}
