package com.bcxin.tenant.domain.events.handlers;

import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.events.OrganizationCreatedEvent;
import com.bcxin.tenant.domain.services.TenantEventService;
import com.bcxin.tenant.domain.services.commands.CreateTenantEventCommand;
import org.springframework.stereotype.Component;

@Component
public class OrganizationCreatedEvent_Handler extends DomainEventHandlerAbstract<OrganizationCreatedEvent> {
    private final TenantEventService tenantEventService;
    private final JsonProvider jsonProvider;

    public OrganizationCreatedEvent_Handler(TenantEventService tenantEventService,
                                            JsonProvider jsonProvider) {
        this.tenantEventService = tenantEventService;
        this.jsonProvider = jsonProvider;
    }

    @Override
    protected void execute(OrganizationCreatedEvent event) {
        this.tenantEventService.create(CreateTenantEventCommand.create(
                EventAction.OrganizationCreated, event.getData().getId(),
                event.getName()));
    }
}
