package com.bcxin.tenant.domain.events.handlers;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.events.EmployeeBeforeCreatedEvent;
import com.bcxin.tenant.domain.services.TenantEventService;
import com.bcxin.tenant.domain.services.TenantUserService;
import com.bcxin.tenant.domain.services.commands.CreateTenantEventCommand;
import com.bcxin.tenant.domain.services.commands.CreateTenantUserByEmployeeCommand;
import com.bcxin.tenant.domain.snapshots.TenantEmployeeSnapshot;
import org.springframework.stereotype.Component;

@Component
public class EmployeeBeforeCreatedEvent_Handler extends DomainEventHandlerAbstract<EmployeeBeforeCreatedEvent> {

    private final TenantUserService tenantUserService;

    public EmployeeBeforeCreatedEvent_Handler(TenantUserService tenantUserService) {
        this.tenantUserService = tenantUserService;
    }

    @Override
    protected void execute(EmployeeBeforeCreatedEvent event) {
        if (event.isEnsureExistsUser()) {
            this.tenantUserService.create(
                    CreateTenantUserByEmployeeCommand.create(
                            event.getData(),
                            event.getName(),
                            event.getTelephone(),
                            event.getCredentialType(),
                            event.getCredentialNumber(),
                            event.getSex(),
                            event.getBirthdate(),
                            event.getNation(),
                            event.getEducation(),
                            event.getPoliticsStatus(),
                            event.getMilitaryStatus(),
                            event.getMaritalStatus(),
                            event.getEmergencyContact(),
                            event.getEmergencyPhone(),
                            event.getAddress(),
                            event.getHouseholdType()
                    )
            );
        }
    }
}
