package com.bcxin.tenant.domain.events;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.events.DomainEventAbstract;
import lombok.Getter;

@Getter
public class TenantCredentialChangedValidateEvent extends DomainEventAbstract<CredentialType> {
    private final String tenantUserId;
    private final String name;
    private final String number;
    private final boolean fromMobile;

    /**
     * Create a new {@code ApplicationEvent}.
     *
     * @param data
     * @param number
     */
    public TenantCredentialChangedValidateEvent(String tenantUserId, String name, CredentialType data, String number, boolean fromMobile) {
        super(data);
        this.name = name;
        this.number = number;
        this.tenantUserId = tenantUserId;
        this.fromMobile = fromMobile;
    }

    public static TenantCredentialChangedValidateEvent create(String tenantUserId, String name, CredentialType data, String number, boolean fromMobile) {
        return new TenantCredentialChangedValidateEvent(tenantUserId, name, data, number, fromMobile);
    }
}
