package com.bcxin.tenant.domain.events;

import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import lombok.Getter;

import java.util.Map;

@Getter
public class OrganizationCreatedEvent extends DomainEventAbstract<OrganizationEntity> {
    private final String name;

    private final Map<String,String> dynamic;

    /**
     * 组织Id
     * @param organization
     * @param name
     * @param dynamic
     */
    public OrganizationCreatedEvent(OrganizationEntity organization, String name, Map<String, String> dynamic) {
        super(organization);
        this.name = name;
        this.dynamic = dynamic;
    }

    public static OrganizationCreatedEvent create(OrganizationEntity organization, String name,Map<String,String> dynamic)
    {
        return new OrganizationCreatedEvent(organization, name, dynamic);
    }
}
