package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 用户表
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "identity_userpassword")
@Entity
public class IdentityUserpasswordEntity extends EntityAbstract implements IAggregate {

    /**
     * ID
     */
    @Id
    private String id;

    /**
     * 用户名
     */
    @Column(name = "user_name",nullable = false, length = 50)
    private String userName;

    /**
     * 密码
     */
    @Column(name = "password",length = 200)
    private String password;

    /**
     * 算法类型
     */
    @Column(name = "algorithm_type",length = 11)
    private int algorithmType;

}






