package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;

/**
 * 部门管理员
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "tenant_department_admins")
@Entity
public class DepartmentAdminEntity extends EntityAbstract implements IAggregate {
    @Id
    private String id;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "organization_id",referencedColumnName = "id",nullable = false,updatable = false)
    private OrganizationEntity organization;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "department_id", referencedColumnName = "id", nullable = false, updatable = false)
    private DepartmentEntity department;

    @Column(name = "department_index_tree")
    private String departmentIndexTree;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "employee_id", referencedColumnName = "id", nullable = false, updatable = false)
    private EmployeeEntity employee;

    @Column(name = "created_time", updatable = false, nullable = false)
    private Timestamp createdTime;

    protected DepartmentAdminEntity() {
        this.createdTime = Timestamp.from(Instant.now());
    }

    public static DepartmentAdminEntity create(DepartmentEntity department, EmployeeEntity employee) {
        DepartmentAdminEntity departmentAdmin = new DepartmentAdminEntity();
        departmentAdmin.setId(UUIDUtil.getShortUuid());

        departmentAdmin.setDepartment(department);
        departmentAdmin.setDepartmentIndexTree(department.getIndexTree());
        departmentAdmin.setEmployee(employee);
        departmentAdmin.setOrganization(department.getOrganization());

        return departmentAdmin;
    }

    public void changeIndexTree(String departmentIndexTree) {
        this.setDepartmentIndexTree(departmentIndexTree);
    }
}
