CREATE TABLE `t_operate_log` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
    `tenant_user_id` varchar(100) DEFAULT NULL COMMENT '用户id',
    `user_name` varchar(50) DEFAULT NULL COMMENT '账号',
    `real_name` varchar(30) DEFAULT NULL COMMENT '姓名',
    `operate_type` tinyint(4) DEFAULT NULL COMMENT '操作类型：1登录，2登出',
    `operate_time` datetime DEFAULT NULL COMMENT '操作时间',
    `operate_content` varchar(200) DEFAULT NULL COMMENT '操作内容',
    `operate_result` varchar(200) DEFAULT NULL COMMENT '操作结果',
    `ip_address` varchar(30) DEFAULT NULL COMMENT 'IP地址',
    PRIMARY KEY (`id`),
    KEY `index_operate_log_tenant_user_id` (`tenant_user_id`) USING BTREE,
    KEY `index_operate_log_user_name` (`user_name`) USING BTREE,
    KEY `index_operate_log_real_name` (`real_name`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8 COMMENT='操作日志表';