 insert into report_employees
SELECT
    e.id id,
	o.id domain_id,
	c.front_photo id_face_photo,
	c.head_photo id_header_photo,
	c.reverse_photo id_nation_photo,
	u.authenticated_time last_auth_time,
	NULL attendance_site_status,
	u.birthdate,
	b.ITEM_bloodType blood_type,
	null certification,
	o.`name`,
	NOW() created_time,
	c.number credential_number,
	c.credential_type,
	'xx' data_restrict,
	d.id depart_id,
	d.`name` depart_name,
	b.ITEM_diseaseHistory disease_history,
	NULL document_id_bool,
	u.education,
	b.ITEM_emergencyContact emergency_contact,
	b.ITEM_emergencyPhone emergency_phone,
	e.hired_date hired_date,
	c.address home_address,
	u.household_type,
	c.address id_address,
CASE
		
		WHEN c.valid_date_to IS NULL THEN
		'永久' ELSE c.valid_date_to 
	END id_validation_e,
CASE
		
		WHEN c.valid_date_from IS NULL THEN
		'永久' ELSE c.valid_date_from 
	END id_validation_s,
	e.insure insure,
CASE
		
		WHEN u.checked_status = 0 THEN
		'未提交' 
		WHEN u.checked_status = 1 THEN
		'已核验' 
		WHEN u.checked_status = 2 THEN
		'已提交' ELSE NULL 
	END is_certified,
	'false' is_deleted,
CASE
		
		WHEN e.`status` = 1 THEN
		'0' ELSE 1 
	END is_in_my_company,
	NULL is_in_mycompany,
	NULL is_state,
CASE
		
		WHEN u.user_type = 2 THEN
		1 ELSE 0 
	END is_veteran,
	e.occupation_type job_type,
	b.ITEM_lastSearchPastTime last_search_past_time,
	NOW() last_updated_time,
	e.leave_time leave_date,
	b.ITEM_licenseLevel license_level,
	u.lon_lat_json lacation,
	u.military_status,
	u.`name` NAME,
	u.nation,
	b.ITEM_nationality nationality,
	'0' occupation_type,
	u.one_inch_color_white_photo one_inch_color_white_photo,
	o.id organization_id,
	u.politics_status,
	u.authenticated_result remark,
	u.sex,
CASE
		
		WHEN u.authenticated_status = '0' THEN
		'未认证' 
		WHEN u.authenticated_status = '1' THEN
		'认证中' 
		WHEN u.authenticated_status = '2' THEN
		'认证失败' 
		WHEN u.authenticated_status = '3' THEN
		'已认证' ELSE NULL 
	END shi_ming,
	u.stature,
	e.superior_id,
	u.telephone,
	e.tenant_user_id,
	u.two_inch_color_blue_photo two_inch_color_blue_photo,
	unix_timestamp(now()) version,
	b.ITEM_workYears work_years 
FROM
	tenant_employees e
	INNER JOIN tenant_users u ON e.tenant_user_id = u.id
	LEFT JOIN tenant_organizations o ON e.organization_id = o.id
	LEFT JOIN tenant_departments d ON e.department_id = d.id
	LEFT JOIN report_employees r ON e.id = r.id
	LEFT JOIN tenant_user_credentials c ON u.selected_credential_id = c.id
	LEFT JOIN baibaodunflow.tlk_securityman b ON c.number = b.ITEM_documentID 
WHERE
	r.id IS NULL  GROUP BY e.id;
