SELECT
    concat(
            ifnull(`a`.`id`, ''),
            '--__XQfjpd9pI9QLFaMYoYm'
        ) AS `id`,
    `a`.`status` AS `item_status`,
    (
        CASE
            WHEN (`a`.`status` = 1) THEN
                '离职'
            ELSE
                '在职'
            END
        ) AS `item_status_label`,
    (
        CASE `c`.`credential_type`
            WHEN 0 THEN
                '居民身份证/户口簿'
            WHEN 1 THEN
                '香港特区护照/身份证'
            WHEN 2 THEN
                '澳门特区护照/身份证明'
            WHEN 3 THEN
                '台湾居民来往大陆通行证'
            WHEN 4 THEN
                '外国护照'
            WHEN 5 THEN
                '退伍军人证'
            WHEN 6 THEN
                '警号'
            WHEN 7 THEN
                '资格证'
            WHEN 8 THEN
                '等级证'
            END
        ) AS `item_documentType_label`,
    `a`.`id` AS `item_userID`,
    concat(
            ifnull(`a`.`tenant_user_id`, ''),
            '___',
            `a`.`id`,
            '--__AOkTvsah9VLicJhQ1FO'
        ) AS `item_user_id`,
    `b`.`name` AS `item_securityName`,
    `b`.`telephone` AS `item_phone`,
    `c`.`credential_type` AS `item_documentType`,
    `c`.`number` AS `item_documentNum`,
    `o`.`name` AS `item_CompanyName`,
    `a`.`hired_date` AS `item_entryDate`,
    `a`.`leave_time` AS `item_outDate`,
    `a`.`organization_id` AS `domainid`,
    `a`.`leave_note` AS `ITEM_outRemark`,
    `a`.`last_sync_time` AS `LASTMODIFIED`
FROM
    (
        (
            (
                `tenant_employees` `a`
                    JOIN `tenant_users` `b` ON (
                    (
                            `a`.`tenant_user_id` = `b`.`id`
                        )
                    )
                )
                JOIN `tenant_organizations` `o` ON (
                (
                        `a`.`organization_id` = `o`.`id`
                    )
                )
            )
            LEFT JOIN `tenant_user_credentials` `c` ON (
            (
                    `c`.`id` = `b`.`selected_credential_id`
                )
            )
        )