package com.bcxin.ferry.service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.ferry.common.utils.IdGeneratorSnowflake;
import com.bcxin.ferry.entity.FerryOperateLogEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import lombok.extern.slf4j.Slf4j;
import com.bcxin.ferry.entity.FerryReceiveOperateLogEntity;
import com.bcxin.ferry.dao.mapper.FerryReceiveOperateLogMapper;

import java.util.Date;

/**
 * 接收操作日志表(ferry_receive_operate_log)服务实现类
 *
 * @author : linchunpeng
 * @date : 2024-3-6
 */
@Slf4j
@Service
public class FerryReceiveOperateLogService extends ServiceImpl<FerryReceiveOperateLogMapper, FerryReceiveOperateLogEntity> {

    @Autowired
    private IdGeneratorSnowflake snowflake;

    /**
     * description：创建日志
     * author：linchunpeng
     * date：2024/3/22
     */
    public void createLog(Long taskId, Integer operateType) {
        FerryReceiveOperateLogEntity log = new FerryReceiveOperateLogEntity();
        log.setId(snowflake.snowflakeId());
        log.setTaskId(taskId);
        log.setOperateType(operateType);
        log.setCreateTime(new Date());
        log.setUpdateTime(new Date());
        this.save(log);
    }

}