/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.bcx.dubbo.common.configs.filters;

import com.bcxin.tenant.bcx.infrastructures.TenantContext;
import com.bcxin.tenant.bcx.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.bcx.infrastructures.exceptions.NotSupportTenantException;
import com.bcxin.tenant.bcx.infrastructures.valueTypes.TrafficTagValueType;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.filter.TokenFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider", "consumer"})
public class AuthTokenFilter
extends TokenFilter {
    private static final Logger logger = LoggerFactory.getLogger(AuthTokenFilter.class);

    public AuthTokenFilter() {
        logger.error("GlobalExceptionFilter v2");
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Object data = invocation.getObjectAttachment("API.CURRENT_TENANT_USER_INFO");
        if (data != null) {
            if (data instanceof TenantEmployeeContext.TenantUserModel) {
                TenantEmployeeContext.TenantUserModel userModel = (TenantEmployeeContext.TenantUserModel)data;
                TenantContext.getInstance().getUserContext().init(userModel);
            } else {
                throw new NotSupportTenantException(String.format("\u5f02\u5e38\u6570\u636e\u7c7b\u578b\u53d1\u751f\u5f02\u5e38:%s", data.getClass()));
            }
        }
        try {
            TrafficTagValueType trafficTagValueType = (TrafficTagValueType)TenantContext.getInstance().resolve(TrafficTagValueType.class);
            RpcContext.getServerContext().setAttachment("PROVIDER_FLOW_TAG_NAME", (Object)trafficTagValueType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.invoke(invoker, invocation);
    }
}

